% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connected.R
\name{connectedness}
\alias{connectedness}
\alias{graph_components}
\alias{graph_cohesion}
\alias{graph_adhesion}
\alias{graph_length}
\alias{graph_diameter}
\alias{node_components}
\alias{node_cuts}
\alias{edge_bridges}
\title{Network connectedness}
\usage{
graph_components(object, method = c("weak", "strong"))

graph_cohesion(object)

graph_adhesion(object)

graph_length(object)

graph_diameter(object)

node_components(object, method = c("weak", "strong"))

node_cuts(object)

edge_bridges(object)
}
\arguments{
\item{object}{An object of a migraph-consistent class:
\itemize{
\item matrix, from base R
\item edgelist, a data frame from base R or tibble from tibble
\item igraph, from the igraph package
\item network, from the network package
\item tbl_graph, from the tidygraph package
}}

\item{method}{For directed networks,
either \code{weak} if edge direction is irrelevant,
or \code{strong} if edge direction is salient.
Ignored if network undirected.}
}
\description{
These functions return values or vectors relating to how connected a network is
and where the nodes or edges that would increase fragmentation are.
}
\section{Functions}{
\itemize{
\item \code{graph_components}: Returns number of components in the network.

\item \code{graph_cohesion}: Returns the minimum number of nodes needed
to remove from the network to increase the number of components.

\item \code{graph_adhesion}: Returns the minimum number of edges needed
to remove from the network to increase the number of components.

\item \code{graph_length}: Returns the average path length in the network.

\item \code{graph_diameter}: Returns the maximum path length in the network.

\item \code{node_components}: Returns nodes' component membership.

\item \code{node_cuts}: Returns logical of which nodes cut
or act as articulation points in a network.

\item \code{edge_bridges}: Returns logical of which nodes cut
or act as articulation points in a network.
}}

\examples{
graph_cohesion(ison_marvel_relationships)
graph_cohesion(to_main_component(ison_marvel_relationships))
graph_adhesion(ison_marvel_relationships)
graph_adhesion(to_main_component(ison_marvel_relationships))
graph_length(ison_marvel_relationships)
graph_length(to_main_component(ison_marvel_relationships))
graph_diameter(ison_marvel_relationships)
graph_diameter(to_main_component(ison_marvel_relationships))
}
\references{
White, Douglas R and Frank Harary 2001.
The Cohesiveness of Blocks In Social Networks: Node Connectivity and Conditional Density.
\emph{Sociological Methodology} 31 (1) : 305-359.
}
