% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_closure.R
\name{closure}
\alias{closure}
\alias{network_reciprocity}
\alias{node_reciprocity}
\alias{network_transitivity}
\alias{node_transitivity}
\alias{network_equivalency}
\alias{network_congruency}
\title{Measures of network closure}
\usage{
network_reciprocity(.data, method = "default")

node_reciprocity(.data)

network_transitivity(.data)

node_transitivity(.data)

network_equivalency(.data)

network_congruency(.data, object2)
}
\arguments{
\item{.data}{An object of a \code{{manynet}}-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{method}{For reciprocity, either \code{default} or \code{ratio}.
See \code{?igraph::reciprocity}}

\item{object2}{Optionally, a second (two-mode) matrix, igraph, or tidygraph}
}
\description{
These functions offer methods for summarising the closure in configurations
in one-, two-, and three-mode networks.
}
\details{
For one-mode networks, shallow wrappers of igraph versions exist via
\code{network_reciprocity} and \code{network_transitivity}.

For two-mode networks, \code{network_equivalency} calculates the proportion of three-paths in the network
that are closed by fourth tie to establish a "shared four-cycle" structure.

For three-mode networks, \code{network_congruency} calculates the proportion of three-paths
spanning two two-mode networks that are closed by a fourth tie to establish a
"congruent four-cycle" structure.
}
\section{Functions}{
\itemize{
\item \code{network_reciprocity()}: Calculate reciprocity in a (usually directed) network

\item \code{node_reciprocity()}: Calculate nodes' reciprocity

\item \code{network_transitivity()}: Calculate transitivity in a network

\item \code{node_transitivity()}: Calculate nodes' transitivity

\item \code{network_equivalency()}: Calculate equivalence or reinforcement
in a (usually two-mode) network

\item \code{network_congruency()}: Calculate congruency across two two-mode networks

}}
\examples{
network_reciprocity(ison_southern_women)
node_reciprocity(to_unweighted(ison_networkers))
network_transitivity(ison_adolescents)
node_transitivity(ison_adolescents)
network_equivalency(ison_southern_women)
}
\references{
Robins, Garry L, and Malcolm Alexander. 2004.
Small worlds among interlocking directors: Network structure and distance in bipartite graphs.
\emph{Computational & Mathematical Organization Theory} 10(1): 69–94.
\doi{10.1023/B:CMOT.0000032580.12184.c0}.

Knoke, David, Mario Diani, James Hollway, and Dimitris C Christopoulos. 2021.
\emph{Multimodal Political Networks}.
Cambridge University Press. Cambridge University Press.
\doi{10.1017/9781108985000}
}
\seealso{
Other measures: 
\code{\link{between_centrality}},
\code{\link{close_centrality}},
\code{\link{cohesion}()},
\code{\link{degree_centrality}},
\code{\link{eigenv_centrality}},
\code{\link{features}},
\code{\link{heterogeneity}},
\code{\link{hierarchy}},
\code{\link{holes}}
}
\concept{measures}
