% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance.R
\name{calc_balanced_precision}
\alias{calc_balanced_precision}
\title{Calculate balanced precision given actual and baseline precision}
\usage{
calc_balanced_precision(precision, prior)
}
\arguments{
\item{precision}{actual precision of the model.}

\item{prior}{baseline precision, aka frequency of positives.
Can be calculated with \link{calc_baseline_precision}}
}
\value{
the expected precision if the data were balanced
}
\description{
Implements Equation 1 from Wu \emph{et al.} 2021 \doi{10.1016/j.ajhg.2021.08.012}.
It is the same as Equation 7 if \code{AUPRC} (aka \code{prAUC}) is used in place of \code{precision}.
}
\examples{
prior <- calc_baseline_precision(otu_mini_bin,
  outcome_colname = "dx",
  pos_outcome = "cancer"
)
calc_balanced_precision(otu_mini_bin_results_rf$performance$Precision, prior)

otu_mini_bin_results_rf$performance \%>\%
  dplyr::mutate(
    balanced_precision = calc_balanced_precision(Precision, prior),
    aubprc = calc_balanced_precision(prAUC, prior)
  ) \%>\%
  dplyr::select(AUC, Precision, balanced_precision, aubprc)

# cumulative performance for a single model
sensspec_1 <- calc_model_sensspec(
  otu_mini_bin_results_glmnet$trained_model,
  otu_mini_bin_results_glmnet$test_data,
  "dx"
)
head(sensspec_1)
prior <- calc_baseline_precision(otu_mini_bin,
  outcome_colname = "dx",
  pos_outcome = "cancer"
)
sensspec_1 \%>\%
  dplyr::mutate(balanced_precision = calc_balanced_precision(precision, prior)) \%>\%
  dplyr::rename(recall = sensitivity) \%>\%
  calc_mean_perf(group_var = recall, sum_var = balanced_precision) \%>\%
  plot_mean_prc(ycol = mean_balanced_precision)
}
\author{
Kelly Sovacool \email{sovacool@umich.edu}
}
