% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{process_allele}
\alias{process_allele}
\title{\code{process_allele}}
\usage{
process_allele(
  seqc,
  bp = BiocParallel::SerialParam(),
  dash_ignore = TRUE,
  accepted_char = c("A", "C", "T", "G"),
  ignore_case = TRUE,
  remove_invariant = FALSE,
  biallelic_only = FALSE
)
}
\arguments{
\item{seqc}{a list containing list of nucleotides. To keep it simple,
use provided read_fasta to import the fasta file.}

\item{bp}{is the biocparallel backend, default to serialParam,
most likely sufficient in most scenario}

\item{dash_ignore}{whether to treat '-' as another type}

\item{accepted_char}{character to accept, default to c("A", "C", "T", "G")}

\item{ignore_case}{whether to be case insensitive, default to TRUE}

\item{remove_invariant}{whether to remove invariant positions, default to FALSE}

\item{biallelic_only}{whether to remove positions with more than 2 alleles, default to FALSE}
}
\value{
Will return the processed allelic profiles.
}
\description{
\code{process_allele} is used to returned the processed allelic profiles, by
removing the allele profile with duplicate name and length different
from most. 1st allele profile with the duplicated name is returned,
the longer length is taken as normal should there be 2 modes.
}
