/*
 * Decompiled with CFR 0.152.
 */
package main;

import analysis.AnalysisParameters;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import main.styles.AllPairsAnalysisStyle;
import main.styles.AnalysisStyle;
import main.styles.ConsecutivePairsAnalysisStyle;
import main.styles.MasterVariableAnalysisStyle;
import main.styles.OnePairAnalysisStyle;
import main.styles.TwoSetsAnalysisStyle;

public class JobParameters {
    public String inputfile = "";
    public AnalysisStyle analysisStyle;
    public int masterVariable;
    public String jobID = "";
    public int notifyWait = 100;
    public String statusFileNamePrefix = "";
    public AnalysisParameters analysisParams;

    public JobParameters(String[] args) throws IllegalArgumentException, IOException {
        if (args.length < 2) {
            throw new IllegalArgumentException("\nnot enough arguments supplied (you need\nto specity an input filename and an\nan analysis style at least)");
        }
        this.inputfile = args[0];
        this.analysisStyle = JobParameters.extractAnalysisStyle(args);
        this.analysisParams = new AnalysisParameters();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            this.processOptionalArgument(arg);
            ++n2;
        }
        if (this.jobID.equals("")) {
            this.jobID = this.defaultJobId();
        }
        this.statusFileNamePrefix = String.valueOf(this.inputfile) + "," + this.jobID;
        FileWriter histstream = null;
        if (this.analysisParams.mineParams.debug != 0) {
            histstream = new FileWriter(String.valueOf(this.inputfile) + "," + this.jobID + ",Debug.txt");
            this.analysisParams.mineParams.debugOut = new BufferedWriter(histstream);
        }
    }

    private String defaultJobId() {
        return this.analysisStyle + "," + "cv=" + this.analysisParams.commonValsThreshold + "," + "B=n^" + this.analysisParams.mineParams.maxNumBoxesExponent;
    }

    public String resultsFileName() {
        return String.valueOf(this.inputfile) + "," + this.jobID + ",Results.csv";
    }

    public String statusFileName() {
        return String.valueOf(this.statusFileNamePrefix) + ",Status.txt";
    }

    public String toString() {
        return "input file = " + this.inputfile + "\n" + "analysis style = " + this.analysisStyle + "\n" + "results file name = '" + this.resultsFileName() + "'\n" + "print status frequency = every " + this.notifyWait + " variable pairs\n" + "status file name = '" + this.statusFileName() + "'\n" + this.analysisParams;
    }

    private static AnalysisStyle extractAnalysisStyle(String[] args) {
        try {
            if (args[1].equals("-allPairs") || args[1].equals("all.pairs")) {
                return new AllPairsAnalysisStyle();
            }
            if (args[1].equals("-adjacentPairs") || args[1].equals("adjacent.pairs")) {
                return new ConsecutivePairsAnalysisStyle();
            }
            if (args[1].equals("-pairsBetween") || args[1].equals("pairs.between")) {
                return new TwoSetsAnalysisStyle(Integer.parseInt(args[2]));
            }
            if (args[1].equals("-masterVariable") || args[1].equals("master.variable")) {
                return new MasterVariableAnalysisStyle(Integer.parseInt(args[2]));
            }
            if (args[1].equals("-onePair") || args[1].equals("one.pair")) {
                return new OnePairAnalysisStyle(Integer.parseInt(args[2]), Integer.parseInt(args[3]));
            }
            if (args.length > 2 && JobParameters.isParsableToInt(args[2])) {
                return new OnePairAnalysisStyle(Integer.parseInt(args[1]), Integer.parseInt(args[2]));
            }
            return new MasterVariableAnalysisStyle(Integer.parseInt(args[1]));
        }
        catch (Exception e) {
            throw new NumberFormatException("\nCould not determine desired analysis style.\nYou must specify an analysis style either\nexplicitly or by specifying one or two variable\nid's. If you specify an analysis style\nexplicitly, make sure you specify the appropriate\nnumber of variable ids.");
        }
    }

    private void processOptionalArgument(String arg) {
        if ((arg = arg.replace(" ", "")).contains("exp=")) {
            this.analysisParams.mineParams.maxNumBoxesExponent = Float.parseFloat(arg.substring(4));
        } else if (arg.contains("cv=")) {
            this.analysisParams.commonValsThreshold = Float.parseFloat(arg.substring(3));
        } else if (arg.contains("notify=")) {
            this.notifyWait = Integer.parseInt(arg.substring(7));
        } else if (arg.contains("id=")) {
            this.jobID = arg.substring(3);
        } else if (arg.contains("gc=")) {
            this.analysisParams.gcWait = Integer.parseInt(arg.substring(3));
        } else if (arg.contains("c=")) {
            this.analysisParams.mineParams.numClumpsFactor = Float.parseFloat(arg.substring(2));
        } else if (arg.contains("d=")) {
            this.analysisParams.mineParams.debug = Integer.parseInt(arg.substring(2));
        }
    }

    public static boolean isParsableToInt(String i) {
        try {
            Integer.parseInt(i);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static void printManPage(String error) {
        System.out.println("======================================================");
        System.out.println("There was a problem with your command-line parameters.");
        System.out.println("\tdetails:\n\t" + error);
        System.out.println("******************************");
        System.out.println("USAGE INSTRUCTIONS");
        System.out.println("******************************");
        System.out.println("java -jar MINE.java   infile   masterVariable   [cv=<float>]   [exp=<float>]   [notify=<int>]   [c=<float>]   [d=<int>]   [gc=int]   [id=<string>]");
        System.out.println("\ninfile - a path to a csv file containing the data. The file must\n\tbe a comma-separated values file, and its name must\n\tend in \".csv\"\n\nmasterVariable - set this to '-allPairs' to compare all pairs of\n\tvariables against each other or to '-adjacentPairs' to\n\tcompare consecutive pairs of variables only. Set to a\n\tnumber i to compare all variables only against the i-th\n\tvariable. Set to a pair i j to compare the i-th variable\n\tagainst the j-th variable. Set to -pairsBetween i to compare\n\teach of the first i variables against each of the rest of the\n\tvariables.\n\ncv - a floating point indicating which percentage of the records\n\tneed to have data in them for both variables before\n\tthose variables are compared. Default value is 0\n\nexp - the exponent in B(n) = n^alpha.  Default value is 0.6\n\nc - this determines how many more clumps there will be than\n\tcolumns in every partition. Default value is 15, meaning\n\tthat when trying to draw Bx grid lines on the x-axis,\n\tthe algorithm will start with at most 15*Bx clumps.\n\nnotify - specifies how often MINE should print the names of the\n\tvariables it is analyzing. For example, if it is 5, MINE\n\twill print the names of the variables in every 5th pair\n\tthat it analyzes. Default value is 100.\n\ngc - the number of variable pairs to analyze before forcing a\n\tgarbage collection. This may never be necessary\n\tdepending on how the Java Virtual Machine is configured.\n\tDefault value is Integer.MAX_VALUE.\n\nd - the level of debug detail. 0 is none, 4 is max. Debug output\n\tis written to infile + ',' + jobID + ',Debug.txt'. Must\n\tbe an integer. Default value is 0.\n\njobID - a string to identify this job.  The program will produce\n\ttwo files; one is called\n\tinfile + ',' + jobID + ',Results.csv', and the other is\n\tcalled\n\tinfile + ',' + jobID + ',Status.txt'.\n\tThe default jobID\n\tspecifies maxNumBoxesExponent and clumpsFactor\n\nEXAMPLE:\n\tjava -jar MINE.jar \"path/to/example.csv\"  0  cv=0.1  exp=0.6  c=10  fewBoxes\n\nThis will run the analysis on the file example.csv. The only\nvariable pairs that will be tried are the first variable against\nthe rest of the variables. Also a variable pair will be ignored\nif less than 10% of the records have values for both the\nvariables in question. The program will use B(n) = n^0.6 and will\nhave the maximal number of clumps be k = 10*Bx. No debug ouput\nwill be produced and two output files will be created:\npath/to/example.txt,fewBoxes,Status.txt, and\npath/to/example.txt,fewBoxes,Results.csv");
    }
}

