# WARNING - Generated by {fusen} from dev/flat_teaching.Rmd: do not edit by hand

# Test basic path segment extraction
test_that("get_path_segment handles basic path extraction correctly", {
  # Test basic forward indexing
  paths <- c("a/b/c", "x/y/z")
  expect_equal(get_path_segment(paths, 1), c("a", "x"))
  expect_equal(get_path_segment(paths, 2), c("b", "y"))
  expect_equal(get_path_segment(paths, 3), c("c", "z"))
  
  # Test backward indexing
  expect_equal(get_path_segment(paths, -1), c("c", "z"))
  expect_equal(get_path_segment(paths, -2), c("b", "y"))
  expect_equal(get_path_segment(paths, -3), c("a", "x"))
})

# Test range extraction functionality
test_that("get_path_segment handles range extraction", {
  paths <- c("a/b/c/d", "w/x/y/z")
  expect_equal(get_path_segment(paths, c(1, 2)), c("a/b", "w/x"))
  expect_equal(get_path_segment(paths, c(2, 3)), c("b/c", "x/y"))
  expect_equal(get_path_segment(paths, c(-2, -1)), c("c/d", "y/z"))
  expect_equal(get_path_segment(paths, c(-3, -1)), c("b/c/d", "x/y/z"))
  
  # Test reversed range
  expect_equal(get_path_segment(paths, c(3, 1)), c("a/b/c", "w/x/y"))
})

# Test path normalization features
test_that("get_path_segment handles path normalization", {
  # Test Windows-style paths
  expect_equal(get_path_segment("C:\\foo\\bar\\baz", 2), "bar")
  
  # Test paths with multiple separators
  expect_equal(get_path_segment("a//b///c", 2), "b")
  
  # Test paths with leading/trailing separators
  expect_equal(get_path_segment("/a/b/c/", 2), "b")
  
  # Test mixed separators
  expect_equal(get_path_segment("a\\b/c//d", c(2, 3)), "b/c")
})

# Test edge cases and boundary conditions
test_that("get_path_segment handles edge cases", {
  # Test empty paths vector
  expect_equal(get_path_segment(character(0)), character(0))
  
  # Test single segment paths
  expect_equal(get_path_segment("foo", 1), "foo")
  expect_equal(get_path_segment("foo", 2), NA_character_)
  
  # Test out of range indices
  paths <- "a/b/c"
  expect_equal(get_path_segment(paths, 4), NA_character_)
  expect_equal(get_path_segment(paths, -4), NA_character_)
  expect_equal(get_path_segment(paths, c(1, 4)), NA_character_)
})

# Test input validation
test_that("get_path_segment validates inputs correctly", {
  # Test missing paths parameter
  expect_error(get_path_segment(), "Parameter 'paths' cannot be empty")
  
  # Test non-character paths
  expect_error(get_path_segment(1:3), "'paths' must be character")
  
  # Test invalid n parameter
  expect_error(get_path_segment("a/b/c", "1"), "'n' must be numeric")
  expect_error(get_path_segment("a/b/c", c(1,2,3)), "'n' must be a single number or a vector of length 2")
  expect_error(get_path_segment("a/b/c", 0), "'n' cannot contain 0")
})

# Test special path formats
test_that("get_path_segment handles special cases", {
  # Test paths with spaces
  expect_equal(get_path_segment("path with/spaces in/file name", 2), "spaces in")
  
  # Test paths with special characters
  expect_equal(get_path_segment("path.with/special-chars/file_name", 2), "special-chars")
  
  # Test empty segments
  expect_equal(get_path_segment("a//b", 2), "b")
})
