% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\docType{package}
\encoding{UTF-8}
\name{mirai.promises-package}
\alias{mirai.promises-package}
\title{mirai.promises: Make 'Mirai' 'Promises'}
\description{
Allows 'mirai' objects encapsulating asynchronous computations, from the
    \CRANpkg{mirai} package by Gao (2023), to be used interchangeably with
    'promise' objects from the \CRANpkg{promises} package by Cheng (2021).
    This facilitates their use with packages \CRANpkg{plumber} by Schloerke
    and Allen (2022) and \CRANpkg{shiny} by Cheng, Allaire, Sievert,
    Schloerke, Xie, Allen, McPherson, Dipert and Borges (2022).
}
\section{Notes}{


    This package provides the methods \code{\link{as.promise.mirai}} and
    \code{\link{as.promise.recvAio}} for the S3 generic
    \code{\link{as.promise}} exported by the 'promises' package.

    An auxiliary function \code{\link{polling}} provides the additional
    option to tune the frequency at which 'mirai' are checked for resolution.

    Package authors wishing to use the S3 methods may simply import the
    function \code{\link{polling}} to make them available.
}

\section{Links}{


    \CRANpkg{mirai} website: \url{https://shikokuchuo.net/mirai/}

    \CRANpkg{nanonext} website: \url{https://shikokuchuo.net/nanonext/}

    NNG website: \url{https://nng.nanomsg.org/}
}

\author{
Charlie Gao \email{charlie.gao@shikokuchuo.net}
    (\href{https://orcid.org/0000-0002-0750-061X}{ORCID})
}
