% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel.R
\name{make_cluster}
\alias{make_cluster}
\alias{stop_cluster}
\title{Make Mirai Cluster}
\usage{
make_cluster(n, url = NULL, remote = NULL, ...)

stop_cluster(cl)
}
\arguments{
\item{n}{integer number of nodes (automatically launched on the local machine
unless 'url' is supplied).}

\item{url}{[default NULL] (specify for remote nodes) the character URL on the
host for remote nodes to dial into, including a port accepting incoming
connections, e.g. 'tcp://10.75.37.40:5555'. Specify a URL with the scheme
'tls+tcp://' to use secure TLS connections.}

\item{remote}{[default NULL] (specify to launch remote nodes) a remote launch
configuration generated by \code{\link{remote_config}} or \code{\link{ssh_config}}.
If not supplied, nodes may be deployed manually on remote resources.}

\item{...}{additional arguments passed onto \code{\link{daemons}}.}

\item{cl}{a 'miraiCluster'.}
}
\value{
For \strong{make_cluster}: An object of class 'miraiCluster' and
    'cluster'. Each 'miraiCluster' has an automatically assigned ID and 'n'
    nodes of class 'miraiNode'. If 'url' is supplied but not 'remote', the
    shell commands for deployment of nodes on remote resources is printed in
    interactive sessions.

    For \strong{stop_cluster}: invisible NULL.
}
\description{
\code{make_cluster} creates a cluster of type 'miraiCluster', which may be
    used as a cluster object for any function in the \pkg{parallel} base
    package such as \code{\link[parallel]{clusterApply}} or
    \code{\link[parallel]{parLapply}}.

\code{stop_cluster} stops a cluster created by \code{make_cluster}.
}
\note{
Requires R >= 4.4 (currently R-devel). Clusters created with this
    function will not work with prior R versions. The functionality is
    experimental prior to release of R 4.4 and the interface is consequently
    subject to change at any time.

    The default behaviour of clusters created by this function is
    designed to map as closely as possible to clusters created by the
    \pkg{parallel} package. However, '...' arguments are passed onto
    \code{\link{daemons}} for additional customisation if desired, although
    resultant behaviour may not be supported.
}
\section{Remote Nodes}{


    Specify 'n' and 'url' to set up a host connection for remote nodes to
    dial into.

    Also specify 'remote' to launch the nodes using a configuration generated
    by \code{\link{remote_config}} or \code{\link{ssh_config}}. In this case,
    the number of nodes is inferred from the configuration provided and 'n'
    is disregarded.

    If 'remote' is not supplied, the shell commands for deploying nodes
    manually on remote resources are automatically printed in interactive
    sessions.

    \code{\link{launch_remote}} may be called at any time on a 'miraiCluster'
    to return the shell commands for deployment of all nodes, or on a
    'miraiNode' to return the command for a single node.
}

\section{Status}{


    Call \code{\link{status}} on a 'miraiCluster' to check the number of
    currently active connections as well as the host URL.
}

\examples{
if (interactive()) {
# Only run examples in interactive R sessions

cl <- make_cluster(2)
cl
cl[[1L]]

Sys.sleep(0.5)
status(cl)

stop_cluster(cl)

}

}
