\name{bfactor}
\alias{bfactor}
\alias{coef,bfactor-method}
\alias{fitted,bfactor-method}
\alias{residuals,bfactor-method}
\alias{summary,bfactor-method}
\title{Full-Information Item Bi-factor Analysis}
\usage{
  bfactor(data, specific, itemtype = NULL, guess = 0, upper
    = 1, SE = FALSE, startvalues = NULL, constrain = NULL,
    freepars = NULL, parprior = NULL, prev.cor = NULL,
    quadpts = 20, verbose = FALSE, debug = FALSE, technical
    = list(), ...)

  \S4method{summary}{bfactor}(object, digits = 3, ...)

  \S4method{coef}{bfactor}(object, allpars = FALSE, digits
    = 3)

  \S4method{fitted}{bfactor}(object, digits = 3, ...)

  \S4method{residuals}{bfactor}(object, restype = 'LD',
    digits = 3, printvalue = NULL, ...)
}
\arguments{
  \item{data}{a \code{matrix} or \code{data.frame} that
  consists of numerically ordered data, with missing data
  coded as \code{NA}}

  \item{specific}{a numeric vector specifying which factor
  loads on which item. For example, if for a 4 item test
  with two specific factors, the first specific factor
  loads on the first two items and the second specific
  factor on the last two, then the vector is
  \code{c(1,1,2,2)}.}

  \item{itemtype}{type of items to be modeled, declared as
  a vector for each item or a single value which will be
  repeated globally. The NULL default assumes that the
  items are ordinal or 2PL, however they may be changed to
  the following: '2PL', '3PL', '3PLu', '4PL', 'graded',
  'gpcm', 'nominal', and 'mcm', for the 2 parameter
  logistic, 3 parameter logistic (lower asymptote and
  upper), 4 parameter logistic, graded response model,
  generalized partial credit model, nominal model, and
  multiple choice models, respectively. If \code{NULL} the
  default assumes that the data follow a '2PL' or 'graded'
  format}

  \item{printvalue}{a numeric value to be specified when
  using the \code{res='exp'} option. Only prints patterns
  that have standardized residuals greater than
  \code{abs(printvalue)}. The default (NULL) prints all
  response patterns}

  \item{guess}{fixed pseudo-guessing parameter. Can be
  entered as a single value to assign a global value or may
  be entered as a numeric vector for each item of length
  \code{ncol(data)}.}

  \item{upper}{fixed upper bound parameters for 4-PL model.
  Can be entered as a single value to assign a global
  guessing parameter or may be entered as a numeric vector
  corresponding to each item}

  \item{SE}{logical; estimate parameter standard errors?}

  \item{allpars}{logical; print all the item parameters
  instead of just the slopes?}

  \item{constrain}{a list of user declared equality
  constraints. To see how to define the parameters
  correctly use \code{constrain = 'index'} initially to see
  how the parameters are labeled. To constrain parameters
  to be equal create a list with separate concatenated
  vectors signifying which parameters to constrain. For
  example, to set parameters 1 and 5 equal, and also set
  parameters 2, 6, and 10 equal use \code{constrain =
  list(c(1,5), c(2,6,10))}}

  \item{parprior}{a list of user declared prior item
  probabilities. To see how to define the parameters
  correctly use \code{parprior = 'index'} initially to see
  how the parameters are labeled. Can define either normal
  (normally for slopes and intercepts) or beta (for
  guessing and upper bounds) prior probabilities. Note that
  for upper bounds the value used in the prior is 1 - u so
  that the lower and upper bounds can function the same. To
  specify a prior the form is c('priortype', ...), where
  normal priors are \code{parprior = list(c(parnumber,
  'norm', mean, sd))} and betas are \code{parprior =
  list(c(parnumber, 'beta', alpha, beta))}.}

  \item{freepars}{a list of user declared logical values
  indicating which parameters to estimate. To see how to
  define the parameters correctly use \code{freepars =
  'index'} initially to see how the parameters are labeled.
  These values may be modified and input back into the
  function by using \code{freepars=newfreepars}. Note that
  user input values must match what the default structure
  would have been}

  \item{startvalues}{a list of user declared start values
  for parameters. To see how to define the parameters
  correctly use \code{startvalues = 'index'} initially to
  see what the defaults would noramlly be. These values may
  be modified and input back into the function by using
  \code{startavalues=newstartvalues}. Note that user input
  values must match what the default structure would have
  been}

  \item{prev.cor}{uses a previously computed correlation
  matrix to be used to estimate starting values for the EM
  estimation}

  \item{quadpts}{number of quadrature points per
  dimension.}

  \item{object}{a model estimated from \code{bfactor} of
  class \code{bfactorClass}}

  \item{restype}{type of residuals to be displayed. Can be
  either \code{'LD'} for a local dependence matrix (Chen &
  Thissen, 1997) or \code{'exp'} for the expected values
  for the frequencies of every response pattern}

  \item{digits}{number of significant digits to be rounded}

  \item{verbose}{logical; print observed log-likelihood
  value at each iteration?}

  \item{debug}{logical; turn on debugging features?}

  \item{technical}{a list containing lower level technical
  parameters for estimation \describe{
  \item{MAXQUAD}{maximum number of quadratures; default
  10000} \item{MSTEPMAXIT}{number of M-step iterations;
  default 25} \item{TOL}{EM convergence threshold; default
  .001} \item{NCYCLES}{maximum number of EM cycles; default
  300} \item{NOWARN}{a logical indicating whether dependent
  packages warnings should be printed; default \code{TRUE}}
  }}

  \item{...}{additional arguments to be passed}
}
\description{
  \code{bfactor} fits a confirmatory maximum likelihood
  bi-factor model to dichotomous and polytomous data under
  the item response theory paradigm. Fits univariate and
  multivariate 1-4PL, graded, (generalized) partial credit,
  nominal, and multiple choice models using a dimensional
  reduction EM algorithm so that regardless of the number
  of specific factors estimated the model only uses a
  two-dimensional quadrature grid for integration.
}
\details{


  \code{bfactor} follows the item factor analysis strategy
  explicated by Gibbons and Hedeker (1992) and Gibbons et
  al. (2007). Nested models may be compared via an
  approximate chi-squared difference test or by a reduction
  in AIC or BIC (accessible via \code{\link{anova}}); note
  that this only makes sense when comparing class
  \code{bfactorClass} models to class \code{mirtClass} or
  \code{polymirtClass}. The general equation used for item
  bi-factor analysis in this package is in the logistic
  form with a scaling correction of 1.702. This correction
  is applied to allow comparison to mainstream programs
  such as TESTFACT 4 (2003) and POLYFACT.

  Unlike TESTFACT 4 (2003) initial start values are
  computed by using information from a quasi-tetrachoric
  correlation matrix, potentially with Carroll's (1945)
  adjustment for chance responses. To begin, a MINRES
  factor analysis with one factor is extracted, and the
  transformed loadings and intercepts (see \link{mirt} for
  more details) are used as starting values for the general
  factor loadings and item intercepts. Values for the
  specific factor loadings are taken to be half the
  magnitude of the extracted general factor loadings. Note
  that while the sign of the loading may be incorrect for
  specific factors (and possibly for some of the general
  factor loadings) the intercepts and general factor
  loadings will be relatively close to the final solution.
  These initial values should be an improvement over the
  TESTFACT initial starting values of 1.414 for all the
  general factor slopes, 1 for all the specific factor
  slopes, and 0 for all the intercepts.

  Factor scores are estimated assuming a normal prior
  distribution and can be appended to the input data matrix
  (\code{full.scores = TRUE}) or displayed in a summary
  table for all the unique response patterns. Fitted and
  residual values can be observed by using the
  \code{fitted} and \code{residuals} functions. To examine
  individuals item plots use \code{\link{itemplot}} which
  will also plot information and surface functions.
  Residuals are computed using the LD statistic (Chen &
  Thissen, 1997) in the lower diagonal of the matrix
  returned by \code{residuals}, and Cramer's V above the
  diagonal.
}
\examples{
\dontrun{

###load SAT12 and compute bifactor model with 3 specific factors
data(SAT12)
data <- key2binary(SAT12,
  key = c(1,4,5,2,3,1,2,1,3,1,2,4,2,1,5,3,4,4,1,4,3,3,4,1,3,5,1,3,1,5,4,5))
specific <- c(2,3,2,3,3,2,1,2,1,1,1,3,1,3,1,2,1,1,3,3,1,1,3,1,3,3,1,3,2,3,1,2)
mod1 <- bfactor(data, specific)
coef(mod1)

###Try with fixed guessing parameters added
guess <- rep(.1,32)
mod2 <- bfactor(data, specific, guess = guess)
coef(mod2)

#########
#simulate data
a <- matrix(c(
1,0.5,NA,
1,0.5,NA,
1,0.5,NA,
1,0.5,NA,
1,0.5,NA,
1,0.5,NA,
1,0.5,NA,
1,NA,0.5,
1,NA,0.5,
1,NA,0.5,
1,NA,0.5,
1,NA,0.5,
1,NA,0.5,
1,NA,0.5),ncol=3,byrow=TRUE)

d <- matrix(c(
-1.0,NA,NA,
-1.5,NA,NA,
 1.5,NA,NA,
 0.0,NA,NA,
2.5,1.0,-1,
3.0,2.0,-0.5,
3.0,2.0,-0.5,
3.0,2.0,-0.5,
2.5,1.0,-1,
2.0,0.0,NA,
-1.0,NA,NA,
-1.5,NA,NA,
 1.5,NA,NA,
 0.0,NA,NA),ncol=3,byrow=TRUE)
items <- rep('dich', 14)
items[5:10] <- 'graded'

sigma <- diag(3)
dataset <- simdata(a,d,2000,itemtype=items,sigma=sigma)

specific <- c(rep(1,7),rep(2,7))
simmod <- bfactor(dataset, specific)
coef(simmod)

    }
}
\author{
  Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\references{
  Chalmers, R., P. (2012). mirt: A Multidimensional Item
  Response Theory Package for the R Environment.
  \emph{Journal of Statistical Software, 48}(6), 1-29.

  Gibbons, R. D., & Hedeker, D. R. (1992). Full-information
  Item Bi-Factor Analysis. \emph{Psychometrika, 57},
  423-436.

  Gibbons, R. D., Darrell, R. B., Hedeker, D., Weiss, D.
  J., Segawa, E., Bhaumik, D. K., Kupfer, D. J., Frank, E.,
  Grochocinski, V. J., & Stover, A. (2007).
  Full-Information item bifactor analysis of graded
  response data. \emph{Applied Psychological Measurement,
  31}, 4-19

  Carroll, J. B. (1945). The effect of difficulty and
  chance success on correlations between items and between
  tests. \emph{Psychometrika, 26}, 347-372.

  Wood, R., Wilson, D. T., Gibbons, R. D., Schilling, S.
  G., Muraki, E., & Bock, R. D. (2003). TESTFACT 4 for
  Windows: Test Scoring, Item Statistics, and
  Full-information Item Factor Analysis [Computer
  software]. Lincolnwood, IL: Scientific Software
  International.
}
\seealso{
  \code{\link{expand.table}}, \code{\link{key2binary}},
  \code{\link{confmirt}}, \code{\link{fscores}}
}
\keyword{models}

