% Generated by roxygen2 (4.0.2): do not edit by hand
\name{generate_pattern}
\alias{generate_pattern}
\title{Generate a CAT pattern}
\usage{
generate_pattern(mirt_object, Theta, choices = NULL, item_answers = NULL)
}
\arguments{
\item{mirt_object}{single group object defined by the \code{mirt} package}

\item{Theta}{a numeric vector indicating the latent theta values for a single person}

\item{choices}{a list of character vectors signifying the possible choices for each item.
  If NULL, a numeric vector is returned indicating the selected category for each item (where
  0 is the lowest possible category)}

\item{item_answers}{(optional) a character vector indicating which of the options in
  \code{choices} should be considered the 'correct' answer. This is required for item types that
  dichotomously score items (e.g., multiple choice items scored with the 3PL model)}
}
\description{
Generate a CAT pattern given various inputs. Returns a character or numeric vector
with length equal to the test size, depending on whether a \code{choices} input was supplied.
}
\examples{
\dontrun{

# return real response vector given choices and (optional) answers
pat <- generate_pattern(mod, Theta = 0, choices = choices, item_answers=answers)
# mirtCAT(questions, mirt_object=mod, local_pattern = pat)

# generate numeric pattern observed in dataset used to define mod
pat2 <- generate_pattern(mod, Theta = 0)
# mirtCAT(mirt_object=mod, local_pattern = pat2)

}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\seealso{
\code{\link{mirtCAT}}
}

