% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_diagnistics.R
\name{dplot.lm}
\alias{dplot.lm}
\title{dplot.lm function}
\usage{
\method{dplot}{lm}(
  mod,
  pch = 19,
  outlier.threshold = 2,
  leverage_threshold = function(n, p) {
     return(2 * p/n)
 },
  influence_threshold = function(n, p) {
     return(8/(n - 2 * p))
 },
  ibands = c(0.5, 1),
  ...
)
}
\arguments{
\item{mod}{an object of class 'lm'}

\item{pch}{the type of point to use, passed to 'plot', the default being 19}

\item{outlier.threshold}{threshold on standardised residuals to declare an outlier, default is 2}

\item{leverage_threshold}{threshold on leverage to be classed as "high leverage", a function of (n,p), the default being 2p/n}

\item{influence_threshold}{threshold on influence to be classed as "high influence", a function (n,p), the default being 2p/n}

\item{ibands}{specifying thresholds at which to discplay Cook's distance on the Studentised residuals vs leverage plot. Default is at 0.5 and 1}

\item{...}{additional arguments, not used as yet}
}
\value{
...
}
\description{
Function for producing diagnostic plots for linear models. Points are identified as being outliers, of high leverage and high
influence. The QQ plot has a confidence band. A plot of leverage vs fitted is given. The plot of Studentised residuals versus
leverage includes along with standard thresholds (at Cook's distance 0.5 and 1) an additional band highlighting influential
observations, whose Cook's distance exceed 8/(n-2p), where n is the number of observations and p is the number of parameters.
The respective threshold for outliers are set, by default, as those observations whose standardised residuals exceed 2.
Obervations are declared as having high leverage if their value exceeds 2p/n.
}
