% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track-management.R
\name{gtrack.path}
\alias{gtrack.path}
\title{Returns the path on disk of a track}
\usage{
gtrack.path(track = NULL)
}
\arguments{
\item{track}{track name or a vector of track names}
}
\value{
A character vector containing the full paths to the tracks on disk.
}
\description{
Returns the path on disk of a track.
}
\details{
This function returns the actual file system path where a track is stored.
The function works with a single track name or a vector of track names.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()
gtrack.path("dense_track")
gtrack.path(c("dense_track", "sparse_track"))

}
\seealso{
\code{\link{gtrack.exists}}, \code{\link{gtrack.ls}},
\code{\link{gintervals.path}}
}
\keyword{~path}
\keyword{~track}
