% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_LS_adaptive.R
\name{impute_LS_adaptive}
\alias{impute_LS_adaptive}
\title{LSimpute_adaptive}
\usage{
impute_LS_adaptive(
  ds,
  k = 10,
  eps = 1e-06,
  min_common_obs = 5,
  r_max_min = 100,
  p_mis_sim = 0.05,
  warn_r_max = FALSE,
  verbose_gene = FALSE,
  verbose_array = FALSE,
  verbose_gene_p = FALSE,
  verbose_array_p = FALSE
)
}
\arguments{
\item{ds}{A data frame or matrix with missing values.}

\item{k}{Directly passed to \code{\link[=impute_LS_gene]{impute_LS_gene()}}.}

\item{eps}{Directly passed to \code{\link[=impute_LS_gene]{impute_LS_gene()}}.}

\item{min_common_obs}{Directly passed to \code{\link[=impute_LS_gene]{impute_LS_gene()}}.}

\item{r_max_min}{Minimum number of nearest genes used for imputation. The
default value (100) corresponds to the choice of Bo et al. (2004).}

\item{p_mis_sim}{Percentage of observed values that are set \code{NA} to estimate
the mixing coefficient \emph{p}. The default value (0.05) corresponds to the
choice of Bo et al. (2004).}

\item{warn_r_max}{Should a warning be given, if \code{r_max_min} is set too high?}

\item{verbose_gene}{Should \code{impute_LS_gene()} be \code{verbose}?}

\item{verbose_array}{Should \code{impute_LS_array()} be \code{verbose}?}

\item{verbose_gene_p}{Should \code{impute_LS_gene()} be \code{verbose} while estimating
\emph{p}?}

\item{verbose_array_p}{Should \code{impute_LS_array()} be \code{verbose} while
estimating \emph{p}?}
}
\value{
An object of the same class as \code{ds} with imputed missing values.
}
\description{
Perform LSimpute_adaptive as described by Bo et al. (2004)
}
\details{
This function performs LSimpute_adaptive as described by Bo et al. (2004).The function assumes that the genes are the rows of \code{ds}.

LSimpute_adaptive combines imputation values from \code{\link[=impute_LS_gene]{impute_LS_gene()}} and
\code{\link[=impute_LS_array]{impute_LS_array()}} using a local (adaptive) approach for the mixing
coefficient \emph{p}.

If the dataset is too small or has too many missing values, there are some
fallback systems implemented. First, if \code{ncol(ds) <= min_common_obs}
(normally, this should not the case!), values are imputed through
\code{\link[=impute_LS_array]{impute_LS_array()}}. Second, \code{r_max_min} is automatically adjusted, if it is
too high. In this case, a warning will be given, if \code{warn_r_max = TRUE}.
Third, if there are not enough observed values in a row (less than
\code{min_common_obs}), the calculation of the mixing coefficient is not possible
and missing values of these rows are imputed with the values from
\code{impute_LS_array()}.

The amount of feedback given from \code{impute_LS_gene()} and \code{impute_LS_array()}
is controlled via \code{verbose_gene}, \code{verbose_array}, \code{verbose_gene_p} and
\code{verbose_array_p}. The last two control the amount of feedback while
estimating \emph{p} and the first two the amount of feedback during the estimation
of the values that are mixed with \emph{p}. Internally,  the imputed dataset from
\code{impute_LS_gene()} is passed on to \code{impute_LS_array()}. Therefore, all
messages from \code{impute_LS_gene()} are truly from \code{impute_LS_gene()} and not a
part of \code{impute_LS_array()}, which never calls \code{impute_LS_gene()} in this
case. Furthermore, all messages from \code{\link[=impute_expected_values]{impute_expected_values()}} belong to
\code{impute_LS_array()}.
}
\examples{
set.seed(123)
ds_mis <- delete_MCAR(mvtnorm::rmvnorm(100, rep(0, 10)), 0.1)
ds_imp <- impute_LS_adaptive(ds_mis)
}
\references{
Bo, T. H., Dysvik, B., & Jonassen, I. (2004). LSimpute: accurate estimation of missing values in microarray data with least squares methods. Nucleic acids research, 32(3), e34
}
\seealso{
Other LSimpute functions: 
\code{\link{impute_LS_array}()},
\code{\link{impute_LS_combined}()},
\code{\link{impute_LS_gene}()}
}
\concept{LSimpute functions}
