% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_location_parameter.R
\name{impute_mode}
\alias{impute_mode}
\title{Mode imputation}
\usage{
impute_mode(ds, type = "columnwise")
}
\arguments{
\item{ds}{A data frame or matrix with missing values.}

\item{type}{One of: "columnwise", "rowwise", "total", "Two-Way" or "Winer"
(see details).}
}
\value{
An object of the same class as \code{ds} with imputed missing values.
}
\description{
Impute an observed mode value for every missing value
}
\details{
This function behaves exactly like \code{\link{impute_mean}}. The only
difference is that it imputes a mode instead of a mean. All \code{type}s
from \code{\link{impute_mean}} are also implemented for \code{impute_mode}.
They are documented in \code{\link{impute_mean}} and
\code{\link{apply_imputation}}.

A mode value of a vector \emph{x} is a most frequent value of \emph{x}.
If this value is not unique, the first occurring mode value in \emph{x} will
be used as imputation value.
}
\examples{
ds <- data.frame(X = c(1:12, rep(8, 8)), Y = 101:120)
ds_mis <- delete_MCAR(ds, 0.2)
ds_imp <- impute_mode(ds_mis)
}
\references{
Beland, S., Pichette, F., & Jolani, S. (2016). Impact on Cronbach's
\eqn{\alpha}{alpha} of simple treatment methods for missing data.
\emph{The Quantitative Methods for Psychology}, 12(1), 57-73.
}
\seealso{
\code{\link{apply_imputation}} the workhorse for this function.

Other location parameter imputation functions: 
\code{\link{impute_mean}()},
\code{\link{impute_median}()}
}
\concept{location parameter imputation functions}
