% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampledNetwork-Class.R
\docType{data}
\name{sampledNetwork}
\alias{sampledNetwork}
\title{An R6 Class to represent sampled network data}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
sampledNetwork
}
\description{
The function \code{\link{sample}} and \code{\link{prepare_data}} produces an instance of an object with class \code{sampledNetwork}.
}
\details{
All fields of this class are only accessible for reading. This class comes with a basic plot, summary and print methods
}
\section{Fields}{

\describe{
\item{\code{samplingRate}}{percentage of observed dyads}

\item{\code{nNodes}}{number of nodes}

\item{\code{nDyads}}{number of dyads}

\item{\code{is_directed}}{direction}

\item{\code{adjacencyMatrix}}{adjacency matrix (with NA)}

\item{\code{covarMatrix}}{the matrix of covariates (if applicable)}

\item{\code{covarArray}}{the array of covariates (if applicable)}

\item{\code{dyads}}{list of potential dyads in the network}

\item{\code{missingDyads}}{array indices of missing dyads}

\item{\code{observedDyads}}{array indices of observed dyads}

\item{\code{samplingMatrix}}{matrix of observed and non-observed edges}

\item{\code{observedNodes}}{vector of observed and non-observed nodes}

\item{\code{NAs}}{boolean for NA entries in the adjacencyMatrix}
}}

\examples{
## SBM parameters
directed <- FALSE
N <- 300 # number of nodes
Q <- 3   # number of clusters
alpha <- rep(1,Q)/Q     # mixture parameter
pi <- diag(.45,Q) + .05 # connectivity matrix

## simulate a SBM without covariates
sbm <- missSBM::simulate(N, alpha, pi, directed)

## Sample network data
sampled_network <-
     missSBM::sample(
       adjacencyMatrix = sbm$adjacencyMatrix,
       sampling        = "double-standard",
       parameters      = c(0.4, 0.8)
     )

summary(sampled_network)
print(sampled_network)
plot(sampled_network, clustering = sbm$memberships)
}
\keyword{datasets}
