% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rec.R
\name{rec}
\alias{rec}
\title{Recode Variable}
\usage{
rec(x, spec, as.factor = FALSE, levels = NULL, as.na = NULL, table = FALSE,
    check = TRUE)
}
\arguments{
\item{x}{a numeric vector, character vector or factor.}

\item{spec}{a character string of recode specifications (see 'Details').}

\item{as.factor}{logical: if \code{TRUE}, character vector will be coerced to a factor.}

\item{levels}{a character vector for specifying the levels in the returned factor.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before conducting the analysis.}

\item{table}{logical: if \code{TRUE}, a cross table variable x recoded variable is printed
on the console.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}
}
\value{
Returns a numeric vector with the same length as \code{x} containing the recoded variable.
}
\description{
This function recodes a numeric vector, character vector, or factor according to recode specifications.
}
\details{
Recode specifications appear in a character string, separated by semicolons (see the examples below),
of the form input = output. If an input value satisfies more than one specification, then the first
(from left to right) applies. If no specification is satisfied, then the input value is carried over
to the result. \code{NA} is allowed in input and output. Several recode specifications are supported:

- single value
For example, 0 = NA

- vector of values
For example, c(7, 8, 9) = 'high'

- range of values
For example, 7:9 = 'C'. The special values lo (lowest value) and hi (highest value) may appear in a range.
For example, \code{lo:10 = 1}. Note that \code{:} is not the R sequence operator. In addition you may not
use \code{:} with the collect operator, e.g., \code{c(1, 3, 5:7)} will cause an error.

- else
For example, \code{else = NA}. Everything that does not fit a previous specification. Note that
\code{else} matches all otherwise unspecified values on input, including \code{NA}.
}
\note{
This function was adapted from the \code{recode()} function in the \pkg{car} package by
John Fox and Sanford Weisberg (2019).
}
\examples{
#--------------------------------------
# Numeric vector
x.num <- c(1, 2, 4, 5, 6, 8, 12, 15, 19, 20)

# Recode 5 = 50 and 19 = 190
rec(x.num, "5 = 50; 19 = 190")

# Recode 1, 2, and 5 = 100 and 4, 6, and 7 = 200 and else = 300
rec(x.num, "c(1, 2, 5) = 100; c(4, 6, 7) = 200; else = 300")

# Recode lowest value to 10 = 100 and 11 to highest value = 200
rec(x.num, "lo:10 = 100; 11:hi = 200")

# Recode 5 = 50 and 19 = 190 and check recoding
rec(x.num, "5 = 50; 19 = 190", table = TRUE)

#--------------------------------------
# Character vector
x.chr <- c("a", "c", "f", "j", "k")

# Recode a to x
rec(x.chr, "'a' = 'X'")

# Recode a and f to x, c and j to y, and else to z
rec(x.chr, "c('a', 'f') = 'x'; c('c', 'j') = 'y'; else = 'z'")

# Recode a to x and coerce to a factor
rec(x.chr, "'a' = 'X'", as.factor = TRUE)

#--------------------------------------
# Factor
x.factor <- factor(c("a", "b", "a", "c", "d", "d", "b", "b", "a"))

# Recode a to x, factor levels ordered alphabetically
rec(x.factor, "'a' = 'x'")

# Recode a to x, user-defined factor levels
rec(x.factor, "'a' = 'x'", levels = c("x", "b", "c", "d"))
}
\references{
Fox, J., & Weisberg S. (2019). \emph{An {R} Companion to Applied Regression} (3rd ed.).
Thousand Oaks CA: Sage. URL: https://socialsciences.mcmaster.ca/jfox/Books/Companion/
}
\seealso{
\code{\link{item.reverse}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
