% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df.head.R
\name{df.head}
\alias{df.head}
\alias{df.tail}
\title{Print the First and Last Rows of a Data Frame}
\usage{
df.head(data, n = 6, digits = 3, width = 20, factor.labels = TRUE,
        row.names = TRUE, row.names.col = "gray2", message = TRUE,
        message.col = "b.blue", check = TRUE, output = TRUE)

df.tail(data, n = 6, digits = 3, width = 20, factor.labels = TRUE,
        row.names = TRUE, row.names.col = "gray2", message = TRUE,
        message.col = "b.blue", check = TRUE, output = TRUE)
}
\arguments{
\item{data}{a data frame.}

\item{n}{a numeric value indicating the number of rows to be
printed on the console.}

\item{digits}{a numeric value indicating the maximum number of decimal
places to be used.}

\item{width}{a numeric value indicating the maximum width of the
character strings in the vector.}

\item{factor.labels}{logical: if \code{TRUE}, factor labels will be printed
on the console.}

\item{row.names}{logical: if \code{TRUE}, row names of the data frame are
printed on the console.}

\item{row.names.col}{a character string indicating the text color for the row
names, see \code{color} argument of the \code{\link{chr.color}}
function.}

\item{message}{logical: if \code{TRUE}, number of remaining rows and columns
are printed on the console.}

\item{message.col}{a character string indicating the text color for the
number of remaining rows and columns printed on the
console, see \code{color} argument of the
\code{\link{chr.color}} function.}

\item{check}{logical: if \code{TRUE} (default), argument specification
is checked.}

\item{output}{logical: if \code{TRUE} (default), output is shown on the
console.}
}
\value{
Returns a list with following entries:

\item{\code{df}}{data frame specified in \code{data} with the first or last \code{n}
rows of the data frame with as many columns as fit on the console}
\item{\code{row.col}}{character string indicating the remaining rows and columns}
}
\description{
The function \code{df.head} prints the first rows of a data frame and the
function \code{df.tail} prints the last rows of a data frame and prints as
many columns as fit on the console supplemented by a summary of the remaining
rows and columns.
}
\examples{
# Example 1: Print first and last six rows
df.head(mtcars)
df.tail(mtcars)

# Example 2: Print first and last six rows without row names
df.head(mtcars, row.names = FALSE)
df.tail(mtcars, row.names = FALSE)

# Example 3: Print first and last three rows with one max. number of decimal places
df.head(mtcars, n = 3, digits = 1)
df.head(mtcars, n = 3, digits = 1)
}
\seealso{
\code{\link{df.check}}, \code{\link{head}}, \code{\link{tail}}, \code{\link{freq}}, \code{\link{descript}}
}
\author{
Takuya Yanagida
}
