% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{av_matrix}
\alias{av_matrix}
\title{Extract the availabilites matrix from the dataset, using column indicies}
\usage{
av_matrix(data, av_cols)
}
\arguments{
\item{data}{The dataset used in the model}

\item{av_cols}{A vector of the the column indicies of the availabilities for each alternative}
}
\value{
Matrix of availabilities for alternatives and the number of choice observations
}
\description{
Extract the availabilites matrix from the dataset, using column indicies
}
\examples{
data("Train", package="mlogit")
Train$ID <- Train$id
Train$CHOICE <- as.numeric(Train$choice)
Train$avail_A <- sample(2, replace=TRUE, size=nrow(Train))-1
Train$avail_B <- sample(2, replace=TRUE, size=nrow(Train))-1
av_matrix(Train, c('avail_A', 'avail_B'))
}
