% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{metrics}
\alias{metrics}
\title{Predictive quality metrics for context based models}
\usage{
metrics(model, ...)
}
\arguments{
\item{model}{The context based model on which to compute predictive metrics.}

\item{...}{Additional parameters for predictive metrics computation.}
}
\value{
The returned value is guaranteed to have at least three components
\itemize{
\item \code{accuracy}: the accuracy of the predictions
\item \code{conf_mat}: the confusion matrix of the predictions, with predicted values
in rows and true values in columns
\item \code{auc}: the AUC of the predictive model
}
}
\description{
This function computes and returns predictive quality metrics for VLMC and
VLMC with covariates.
}
\details{
A context based model computes transition probabilities for its contexts.
Using a maximum transition probability decision rule, this can be used to
"predict" the new state that is the more likely to follow the current one,
given the context. The quality of these predictions is evaluated using
standard metrics including:
\itemize{
\item accuracy
\item the full confusion matrix
\item the area under the roc curve (AUC), considering the context based model as
a (conditional) probability estimator. We use Hand and Till (2001) multiclass
AUC in case of a state space with more than 2 states
}
}
\examples{
pc <- powerconsumption[powerconsumption$week == 5, ]
breaks <- c(
  0,
  median(powerconsumption$active_power, na.rm = TRUE),
  max(powerconsumption$active_power, na.rm = TRUE)
)
labels <- c(0, 1)
dts <- cut(pc$active_power, breaks = breaks, labels = labels)
model <- vlmc(dts)
metrics(model)

}
\references{
David J. Hand and Robert J. Till (2001). "A Simple Generalisation of the Area
Under the ROC Curve for Multiple Class Classification
Problems." \emph{Machine Learning} 45(2), p. 171--186. DOI:
\doi{10.1023/A:1010920819831}.
}
\seealso{
\code{\link[=metrics.vlmc]{metrics.vlmc()}}, \code{\link[=contexts.covlmc]{contexts.covlmc()}}
}
