% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_methods.R
\docType{methods}
\name{getYieldGear}
\alias{getYieldGear}
\alias{getYieldGear,MizerSim-method}
\title{Calculate the total yield per gear and species}
\usage{
getYieldGear(object)

\S4method{getYieldGear}{MizerSim}(object)
}
\arguments{
\item{object}{An object of class \code{MizerSim}.}
}
\value{
An array containing the total yield (time x gear x species)
}
\description{
Calculates the total yield per gear and species at each simulation
time step.

Calculate the total yield per gear from a \code{MizerSim} object
}
\examples{
\dontrun{
data(NS_species_params_gears)
data(inter)
params <- MizerParams(NS_species_params_gears, inter)
# With constant fishing effort for all gears for 20 time steps
sim <- project(params, t_max = 20, effort = 0.5)
getYieldGear(sim)
}
}
\seealso{
\code{\link{getYield}}
}
