% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\docType{methods}
\name{plotGrowthCurves}
\alias{plotGrowthCurves}
\alias{plotGrowthCurves,MizerSim-method}
\alias{plotGrowthCurves,MizerParams-method}
\title{Plot growth curves giving weight as a function of age}
\usage{
plotGrowthCurves(object, ...)

\S4method{plotGrowthCurves}{MizerSim}(object,
  species = as.character(sim@params@species_params$species),
  max_age = 20, percentage = FALSE, print_it = TRUE)

\S4method{plotGrowthCurves}{MizerParams}(object,
  species = as.character(params@species_params$species), max_age = 20,
  percentage = FALSE, print_it = TRUE)
}
\arguments{
\item{object}{MizerSim or MizerParams object}

\item{...}{Other arguments (unused)}

\item{species}{Name or vector of names of the species to be plotted. By
default all species are plotted.}

\item{max_age}{The age up to which the weight is to be plotted. Default is 20}

\item{percentage}{Boolean value. If TRUE, the size is shown as a percentage
of the maximal size.}

\item{print_it}{Display the plot, or just return the ggplot2 object.
Defaults to TRUE}
}
\value{
A ggplot2 object
}
\description{
If given a \linkS4class{MizerSim} object, uses the growth rates at the final
time of a simulation to calculate the size at age. If given a
\linkS4class{MizerParams} object, uses the initial growth rates instead.
}
\details{
When the growth curve for only a single species is plotted, horizontal
lines are included that indicate the maturity size and the maximum size for 
that species. If furthermore the species parameters contain the variables
a and b for length to weight conversion and the von Bertalanffy parameter
k_vb, then the von Bertalanffy growth curve is superimposed in black.
}
\examples{
\dontrun{
data(NS_species_params_gears)
data(inter)
params <- MizerParams(NS_species_params_gears, inter)
sim <- project(params, effort=1, t_max=20, t_save = 2)
plotGrowthCurves(sim, percentage = TRUE)
plotGrowthCurves(sim, species = "Cod", max_age = 24)
}
}
