% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MizerSim-class.R
\name{idxFinalT}
\alias{idxFinalT}
\title{Time index at end of simulation}
\usage{
idxFinalT(sim)
}
\arguments{
\item{sim}{A MizerSim object}
}
\value{
An integer giving the index for extracting the
results for the final time step
}
\description{
Time index at end of simulation
}
\examples{
\dontrun{
sim <- project(NS_params, t_max = 12, t_save = 0.5)
idx <- idxFinalT(sim)
idx
# This coincides with
length(getTimes(sim))
# and corresponds to the final time
getTimes(sim)[idx]
# We can use this index to extract the result at the final time
identical(N(sim)[idx, , ], finalN(sim))
identical(NResource(sim)[idx, ], finalNResource(sim))
}
}
