% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setFishing.R
\name{initial_effort}
\alias{initial_effort}
\alias{initial_effort<-}
\alias{validEffortVector}
\title{Initial fishing effort}
\usage{
initial_effort(params)

initial_effort(params) <- value

validEffortVector(effort, params)
}
\arguments{
\item{params}{A MizerParams object}

\item{value}{The initial fishing effort}

\item{effort}{A vector or scalar.}
}
\description{
The fishing effort is a named vector, specifying for each fishing gear the
effort invested into fishing with that gear. The effort value for each gear
is multiplied by the catchability and the selectivity to determine the
fishing mortality imposed by that gear, see \code{\link[=setFishing]{setFishing()}} for more details.

The function also accepts an \code{effort} that is not yet valid:
}
\details{
The initial effort you have set can be overruled when running a simulation
by providing an \code{effort} argument to \code{\link[=project]{project()}} which allows you to
specify a time-varying effort.

\itemize{
\item a scalar, which is then replicated for each gear
\item an unnamed vector, which is then assumed to be in the same order as the
gears in the params object
\item a named vector in which the gear names have a different order than in the
params object. This is then sorted correctly.
\item a named vector which only supplies values for some of the gears.
The effort for the other gears is then set to zero.
}

An \code{effort} argument will lead to an error if it is either
\itemize{
\item unnamed and of the wrong length
\item named but where some names do not match any of the gears
\item not numeric
}
}
\concept{helper}
