% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reproduction.R
\name{constantEggRDI}
\alias{constantEggRDI}
\title{Choose egg production to keep egg density constant}
\usage{
constantEggRDI(params, n, e_growth, mort, ...)
}
\arguments{
\item{params}{A MizerParams object}

\item{n}{A matrix of species abundances (species x size).}

\item{e_growth}{A two dimensional array (species x size) holding the energy
available for growth as calculated by \code{\link[=mizerEGrowth]{mizerEGrowth()}}.}

\item{mort}{A two dimensional array (species x size) holding the mortality
rate as calculated by \code{\link[=mizerMort]{mizerMort()}}.}

\item{...}{Unused}
}
\value{
Vector with the value for each species
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
The new egg production is set to compensate for the loss of individuals from
the smallest size class through growth and mortality. The result should not
be modified by density dependence, so this should be used together with
the \code{noRDD()} function, see example.
}
\examples{
\donttest{
# choose an example params object
params <- NS_params
# We set the reproduction rate functions
params <- setRateFunction(params, "RDI", "constantEggRDI")
params <- setRateFunction(params, "RDD", "noRDD")
# Now the egg density should stay fixed no matter how we fish
sim <- project(params, effort = 10, progress_bar = FALSE)
# To check that indeed the egg densities have not changed, we first construct
# the indices for addressing the egg densities
no_sp <- nrow(params@species_params)
idx <- (params@w_min_idx - 1) * no_sp + (1:no_sp)
# Now we can check equality between egg densities at the start and the end
all.equal(finalN(sim)[idx], initialN(params)[idx])
}
}
\seealso{
Other functions calculating density-dependent reproduction rate: 
\code{\link{BevertonHoltRDD}()},
\code{\link{RickerRDD}()},
\code{\link{SheperdRDD}()},
\code{\link{constantRDD}()},
\code{\link{noRDD}()}
}
\concept{functions calculating density-dependent reproduction rate}
