% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_predictions.R
\name{predictions}
\alias{predictions}
\title{predictions}
\usage{
predictions(object, newdata, na.rm = FALSE, ncores = -1L, ...)
}
\arguments{
\item{object}{An R6 object of class \code{"MLCrossValidation"} for which the
predictions should be computed.}

\item{newdata}{The new data for which predictions should be made using
the \code{model}.}

\item{na.rm}{A logical. If missings should be removed before computing the
mean and standard deviation of the performance across different folds for
each observation in \code{newdata}.}

\item{ncores}{An integer to specify the number of cores used for
parallelization (default: \code{-1L}).}

\item{...}{A list. Further arguments required to compute the predictions.}
}
\value{
The function returns a data.table of class \code{"mlexPredictions"}with
one row for each observation in \code{newdata} and the columns containing
the predictions for each fold, along with the mean and standard deviation
across all folds.
}
\description{
Apply an R6 object of class \code{"MLCrossValidation"} to new data
to compute predictions.
}
\examples{
dataset <- do.call(
  cbind,
  c(sapply(paste0("col", 1:6), function(x) {
    rnorm(n = 500)
    },
    USE.NAMES = TRUE,
    simplify = FALSE
   ),
   list(target = sample(0:1, 500, TRUE))
))

fold_list <- splitTools::create_folds(
  y = dataset[, 7],
  k = 3,
  type = "stratified",
  seed = 123
)

glm_optimization <- mlexperiments::MLCrossValidation$new(
  learner = LearnerGlm$new(),
  fold_list = fold_list,
  seed = 123
)

glm_optimization$learner_args <- list(family = binomial(link = "logit"))
glm_optimization$predict_args <- list(type = "response")
glm_optimization$performance_metric_args <- list(
   positive = 1,
   negative =0
)
glm_optimization$performance_metric <- metric("AUC")
glm_optimization$return_models <- TRUE

# set data
glm_optimization$set_data(
  x = data.matrix(dataset[, -7]),
  y = dataset[, 7]
)

cv_results <- glm_optimization$execute()

# predictions
preds <- mlexperiments::predictions(
  object = glm_optimization,
  newdata = data.matrix(dataset[, -7]),
  na.rm = FALSE,
  ncores = 2L,
  type = "response"
)
head(preds)

}
