% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grake.R
\encoding{utf8}
\name{dss}
\alias{dss}
\title{Calibrate sample weights}
\usage{
dss(
  X,
  d,
  totals,
  q = NULL,
  method = c("raking", "linear", "logit"),
  bounds = NULL,
  maxit = 500,
  ginv = gginv(),
  tol = 1e-06,
  attributes = FALSE
)
}
\arguments{
\item{X}{a matrix of calibration variables.}

\item{d}{a numeric vector giving the initial sample (or design) weights.}

\item{totals}{a numeric vector of population totals corresponding to the
calibration variables in \code{X}.}

\item{q}{a numeric vector of positive values accounting for
heteroscedasticity.  Small values reduce the variation of the
\emph{g}-weights.}

\item{method}{a character string specifying the calibration method to be
used.  Possible values are \code{"linear"} for the linear method,
\code{"raking"} for the multiplicative method known as raking and
\code{"logit"} for the logit method.}

\item{bounds}{a numeric vector of length two giving bounds for the g-weights
to be used in the logit method.  The first value gives the lower bound (which
must be smaller than or equal to 1) and the second value gives the upper
bound (which must be larger than or equal to 1).  If \code{NULL}, the
bounds are set to \code{c(0, 10)}.}

\item{maxit}{a numeric value giving the maximum number of iterations.}

\item{ginv}{a function that computes the Moore-Penrose generalized
inverse (default: an optimized version of \code{\link[MASS:ginv]{MASS::ginv()}}). In
some cases it is possible to speed up the process by using
a function that computes a "regular" matrix inverse such as
\code{{solve.default}}.}

\item{tol}{relative tolerance; convergence is achieved if the difference of
all residuals (relative to the corresponding total) is smaller than this
tolerance.}

\item{attributes}{should additional attributes (currently
\code{success}, \code{iterations}, \code{method} and \code{bounds})
be added to the result? If \code{FALSE} (default), a warning is given
if convergence within the given relative tolerance could not be achieved.}
}
\value{
A numeric vector containing the \emph{g}-weights.
}
\description{
Calibrate sample weights according to known marginal population totals.
Based on initial sample weights, the so-called \emph{g}-weights are computed
by generalized raking procedures.
The final sample weights need to be computed by multiplying the resulting
\emph{g}-weights with the initial sample weights.
}
\note{
This is a faster implementation of parts of
\code{\link[sampling:calib]{sampling::calib()}} from package \code{sampling}.  Note that the
default calibration method is raking and that the truncated linear method is
not yet implemented.
}
\examples{
obs <- 1000
vars <- 100
Xs <- matrix(runif(obs * vars), nrow = obs)
d <- runif(obs) / obs
totals <- rep(1, vars)
g <- dss(Xs, d, totals, method = "linear", ginv = solve)
g2 <- dss(Xs, d, totals, method = "raking")
}
\references{
Deville, J.-C. and \enc{Särndal}{Saerndal}, C.-E. (1992)
Calibration estimators in survey sampling. \emph{Journal of the American
Statistical Association}, \strong{87}(418), 376--382.

Deville, J.-C., \enc{Särndal}{Saerndal}, C.-E. and Sautory, O. (1993)
Generalized raking procedures in survey sampling. \emph{Journal of the
American Statistical Association}, \strong{88}(423), 1013--1020.
}
\author{
Andreas Alfons, with improvements by Kirill Müller
}
\keyword{survey}
