% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatten_ml_fit_problem.R
\name{flatten_ml_fit_problem}
\alias{flatten_ml_fit_problem}
\alias{as_flat_ml_fit_problem}
\title{Return a flattened representation of a multi-level fitting problem instance}
\usage{
flatten_ml_fit_problem(
  ml_problem,
  model_matrix_type = c("combined", "separate"),
  verbose = FALSE
)

as_flat_ml_fit_problem(x, model_matrix_type = c("combined", "separate"), ...)
}
\arguments{
\item{ml_problem}{A fitting problem created by
\code{\link[=ml_problem]{ml_problem()}} or returned by \code{\link[=flatten_ml_fit_problem]{flatten_ml_fit_problem()}}.}

\item{model_matrix_type}{Which model matrix building strategy to use? See details.}

\item{verbose}{If \code{TRUE}, print diagnostic output.}

\item{x}{An object}

\item{...}{Further parameters passed to the algorithm}
}
\value{
An object of classes \code{flat_ml_fit_problem},
essentially a named list.
}
\description{
This function transforms a multi-level fitting problem to a representation
more suitable for applying the algorithms:  A matrix with one row per controlled
attribute and one column per household, a weight vector with one weight
per household, and a control vector.
}
\details{
The standard way to build a model matrix (\code{model_matrix = "combined"})
is to include intercepts and avoid repeating redundant attributes.
A simpler model matrix specification, available via \code{model_matrix = "separate"},
is suggested by Ye et al. (2009) and required for the \code{\link[=ml_fit_ipu]{ml_fit_ipu()}} implementation:
Here, simply one column per target value is used, which
results in a larger model matrix if more than one control is given.
}
\examples{
path <- toy_example("Tiny")
flat_problem <- flatten_ml_fit_problem(ml_problem = readRDS(path))
flat_problem

fit <- ml_fit_dss(flat_problem)
fit$flat_weights
fit$weights
}
\seealso{
\code{\link[=ml_fit]{ml_fit()}}
}
