% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_field_json.R
\name{read_field_json}
\alias{read_field_json}
\title{Read Field Data in JSON Format}
\usage{
read_field_json(
  paths,
  wells = mlms::wells,
  ports = mlms::ports,
  tz = "America/Denver"
)
}
\arguments{
\item{paths}{'character' vector.
Paths to the JSON files to read.}

\item{wells}{'data.frame' table.
MLMS well data, see \code{\link{wells}} dataset for data structure.}

\item{ports}{'data.frame' table.
MLMS measurement port data, see \code{\link{ports}} dataset for data structure.}

\item{tz}{'character' string.
Time zone specification.
Defaults to America/Denver.}
}
\value{
A list of data frame components.
See \code{\link{visits}} and \code{\link{heads}} datasets for example output.
}
\description{
Read Multilevel Monitoring System (MLMS) field data in JSON format.
}
\examples{
l <- system.file("extdata/ex-field.json", package = "mlms") |>
  read_field_json()
str(l, max.level = 1)
}
\seealso{
\code{\link{write_field_json}} function for writing field data to file in JSON format.
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
