% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsqmlm.R
\name{rsqmlm}
\alias{rsqmlm}
\title{Calculates R-squared from lmer models}
\usage{
rsqmlm(model, by_cluster = FALSE)
}
\arguments{
\item{model}{A linear mixed-effects model of class lmerMod or lmerModLmerTest}

\item{by_cluster}{Logical, if TRUE returns variance explained at each level}
}
\value{
Computes the percent variance explained by the model.
}
\description{
Calculates variance explained by lme4-fitted mixed-effects models.
}
\examples{
# Read in data
data(instruction)
# Center mathkind by classid
center(dataset = instruction, x = "mathkind", grouping = "classid")
# Create model
mod <- lme4::lmer(mathgain ~ classid_mathkind.cmn +
classid_mathkind.devcmn + (1 | classid), data = instruction)
# Calculate r-squared
rsq <- rsqmlm(mod)
rsq
rsq$marginal
rsq$conditional

}
\references{
Nakagawa, S., Johnson, P. C., & Schielzeth, H. (2017). The coefficient of determination R 2 and intra-class correlation coefficient from generalized linear mixed-effects models revisited and expanded. Journal of the Royal Society Interface, 14(134), 20170213.
}
