% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knn_classifier.R
\encoding{UTF-8}
\name{knn_classifier}
\alias{knn_classifier}
\title{Constructs a nearest neighbours-based classifier and returns the predictions
for a test set}
\usage{
knn_classifier(dataset, classes, index_test, distance, k, ...)
}
\arguments{
\item{dataset}{A list of MTS (numerical matrices).}

\item{classes}{A vector containing the class labels associated with the
elements in \code{dataset}.}

\item{index_test}{The indexes associated with the test elements in \code{dataset},
i.e., the elements for which predictions will be computed.}

\item{distance}{The corresponding distance measure to compute the
nearest neighbours-based classifier (must be one the functions implemented
in \pkg{mlmts}, as a string).}

\item{k}{The number of neighbours.}

\item{...}{Additional parameters for the function with respect to the considered
distance.}
}
\value{
The class labels for the elements in the test set.
}
\description{
\code{knn_classifier} returns the predictions for a test set concerning a
nearest neighbours-based classifier.
}
\details{
Given a collection of MTS containing the training and test set,
the function constructs a nearest neighbours-based classifier
based on a given dissimilarity measure. The corresponding predictions
for the elements in the test set are returned.
}
\examples{
predictions_1_nn <- knn_classifier(BasicMotions$data[1 : 10], BasicMotions$classes[1 : 10],
index_test = 6 : 10, distance = 'dis_modwt', k = 1) # Computing the
# predictions for the test elements in dataset BasicMotions according to
# a 1-nearest neighbour classifier based on dis_modtw.
predictions_1_nn
}
\author{
Ángel López-Oriona, José A. Vilar
}
