% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateFilterValues.R
\name{getFilterValues}
\alias{getFilterValues}
\title{Calculates feature filter values.}
\usage{
getFilterValues(task, method = "randomForestSRC.rfsrc",
  nselect = getTaskNFeats(task), ...)
}
\arguments{
\item{task}{(\link{Task})\cr
The task.}

\item{method}{(\code{character(1)})\cr
Filter method, see above.
Default is \dQuote{randomForestSRC.rfsrc}.}

\item{nselect}{(\code{integer(1)})\cr
Number of scores to request. Scores are getting calculated for all features per default.}

\item{...}{(any)\cr
Passed down to selected method.}
}
\value{
(\link{FilterValues}).
}
\description{
Calculates numerical filter values for features.
For a list of features, use \link{listFilterMethods}.
}
\note{
\code{getFilterValues} is deprecated in favor of \link{generateFilterValuesData}.
}
\seealso{
Other filter: \code{\link{filterFeatures}},
  \code{\link{generateFilterValuesData}},
  \code{\link{getFilteredFeatures}},
  \code{\link{listFilterMethods}},
  \code{\link{makeFilterWrapper}},
  \code{\link{makeFilter}}, \code{\link{plotFilterValues}}

Other generate_plot_data: \code{\link{generateCalibrationData}},
  \code{\link{generateCritDifferencesData}},
  \code{\link{generateFeatureImportanceData}},
  \code{\link{generateFilterValuesData}},
  \code{\link{generateLearningCurveData}},
  \code{\link{generatePartialDependenceData}},
  \code{\link{generateThreshVsPerfData}},
  \code{\link{plotFilterValues}}

Other filter: \code{\link{filterFeatures}},
  \code{\link{generateFilterValuesData}},
  \code{\link{getFilteredFeatures}},
  \code{\link{listFilterMethods}},
  \code{\link{makeFilterWrapper}},
  \code{\link{makeFilter}}, \code{\link{plotFilterValues}}
}
