% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResamplingHoldout.R
\name{ResamplingHoldout}
\alias{ResamplingHoldout}
\alias{mlr_resamplings_holdout}
\title{Holdout Resampling}
\format{\link[R6:R6Class]{R6::R6Class} inheriting from \link{Resampling}.}
\description{
Splits data into a training set and a test set.
Parameter \code{ratio} determines the ratio of observation going into the training set (default: 2/3).
}
\section{Construction}{
\preformatted{ResamplingHoldout$new()
mlr_resamplings$get("holdout")
rsmp("holdout")
}
}

\section{Fields}{

See \link{Resampling}.
}

\section{Methods}{

See \link{Resampling}.
}

\section{Parameters}{

\itemize{
\item \code{ratio} :: \code{numeric(1)}\cr
Ratio of observations to put into the training set.
}
}

\examples{
# Create a task with 10 observations
task = tsk("iris")
task$filter(1:10)

# Instantiate Resampling
rho = rsmp("holdout", ratio = 0.5)
rho$instantiate(task)

# Individual sets:
rho$train_set(1)
rho$test_set(1)
intersect(rho$train_set(1), rho$test_set(1))

# Internal storage:
rho$instance # simple list
}
\seealso{
\link[mlr3misc:Dictionary]{Dictionary} of \link[=Resampling]{Resamplings}: \link{mlr_resamplings}

\code{as.data.table(mlr_resamplings)} for a complete table of all (also dynamically created) \link{Resampling} implementations.
}
