% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_result_data.R
\name{as_result_data}
\alias{as_result_data}
\title{Convert to ResultData}
\usage{
as_result_data(
  task,
  learners,
  resampling,
  iterations,
  predictions,
  learner_states = NULL,
  store_backends = TRUE
)
}
\arguments{
\item{task}{(\link{Task}).}

\item{learners}{(list of trained \link{Learner}s).}

\item{resampling}{(\link{Resampling}).}

\item{iterations}{(\code{integer()}).}

\item{predictions}{(list of list of \link{Prediction}s).}

\item{learner_states}{(\code{list()})\cr
Learner states. If not provided, the states of \code{learners} are automatically extracted.}

\item{store_backends}{(\code{logical(1)})\cr
If set to \code{FALSE}, the backends of the \link{Task}s provided in \code{data} are
removed.}
}
\value{
\code{ResultData} object which can be passed to the constructor of \link{ResampleResult}.
}
\description{
This function allows to construct or convert to a \link{ResultData} object, the
result container used by \link{ResampleResult} and \link{BenchmarkResult}.
A \link{ResampleResult} or \link{BenchmarkResult} can be initialized with the returned object.
Note that \link{ResampleResult}s can be converted to a \link{BenchmarkResult} with \code{\link[=as_benchmark_result]{as_benchmark_result()}}
and multiple \link{BenchmarkResult}s can be combined to a larger \link{BenchmarkResult} with the
\verb{$combine()} method of \link{BenchmarkResult}.
}
\examples{
task = tsk("penguins")
learner = lrn("classif.rpart")
resampling = rsmp("cv", folds = 2)$instantiate(task)
iterations = seq_len(resampling$iters)

# manually train two learners.
# store learners and predictions
learners = list()
predictions = list()
for (i in iterations) {
  l = learner$clone(deep = TRUE)
  learners[[i]] = l$train(task, row_ids = resampling$train_set(i))
  predictions[[i]] = list(test = l$predict(task, row_ids = resampling$test_set(i)))
}

rdata = as_result_data(task, learners, resampling, iterations, predictions)
ResampleResult$new(rdata)
}
