% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CallbackFSelect.R
\name{callback_fselect}
\alias{callback_fselect}
\title{Create Feature Selection Callback}
\usage{
callback_fselect(
  id,
  label = NA_character_,
  man = NA_character_,
  on_optimization_begin = NULL,
  on_optimizer_before_eval = NULL,
  on_eval_after_design = NULL,
  on_eval_after_benchmark = NULL,
  on_eval_before_archive = NULL,
  on_optimizer_after_eval = NULL,
  on_result = NULL,
  on_optimization_end = NULL
)
}
\arguments{
\item{id}{(\code{character(1)})\cr
Identifier for the new instance.}

\item{label}{(\code{character(1)})\cr
Label for the new instance.}

\item{man}{(\code{character(1)})\cr
String in the format \verb{[pkg]::[topic]} pointing to a manual page for this object.
The referenced help package can be opened via method \verb{$help()}.}

\item{on_optimization_begin}{(\verb{function()})\cr
Stage called at the beginning of the optimization.
Called in \code{Optimizer$optimize()}.
The context available is \link[bbotk:ContextOptimization]{bbotk::ContextOptimization}.}

\item{on_optimizer_before_eval}{(\verb{function()})\cr
Stage called after the optimizer proposes points.
Called in \code{OptimInstance$eval_batch()}.
The context available is \link[bbotk:ContextOptimization]{bbotk::ContextOptimization}.}

\item{on_eval_after_design}{(\verb{function()})\cr
Stage called after design is created.
Called in \code{ObjectiveFSelect$eval_many()}.
The context available is \link{ContextEval}.}

\item{on_eval_after_benchmark}{(\verb{function()})\cr
Stage called after feature sets are evaluated.
Called in \code{ObjectiveFSelect$eval_many()}.
The context available is \link{ContextEval}.}

\item{on_eval_before_archive}{(\verb{function()})\cr
Stage called before performance values are written to the archive.
Called in \code{ObjectiveFSelect$eval_many()}.
The context available is \link{ContextEval}.}

\item{on_optimizer_after_eval}{(\verb{function()})\cr
Stage called after points are evaluated.
Called in \code{OptimInstance$eval_batch()}.
The context available is \link[bbotk:ContextOptimization]{bbotk::ContextOptimization}.}

\item{on_result}{(\verb{function()})\cr
Stage called after result are written.
Called in \code{OptimInstance$assign_result()}.
The context available is \link[bbotk:ContextOptimization]{bbotk::ContextOptimization}.}

\item{on_optimization_end}{(\verb{function()})\cr
Stage called at the end of the optimization.
Called in \code{Optimizer$optimize()}.
The context available is \link[bbotk:ContextOptimization]{bbotk::ContextOptimization}.}
}
\description{
Function to create a \link{CallbackFSelect}.
Predefined callbacks are stored in the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_callbacks} and can be retrieved with \code{\link[=clbk]{clbk()}}.

Feature selection callbacks can be called from different stages of feature selection.
The stages are prefixed with \verb{on_*}.

\if{html}{\out{<div class="sourceCode">}}\preformatted{Start Feature Selection
     - on_optimization_begin
    Start FSelect Batch
         - on_optimizer_before_eval
        Start Evaluation
             - on_eval_after_design
             - on_eval_after_benchmark
             - on_eval_before_archive
        End Evaluation
         - on_optimizer_after_eval
    End FSelect Batch
     - on_result
     - on_optimization_end
End Feature Selection
}\if{html}{\out{</div>}}

See also the section on parameters for more information on the stages.
A feature selection callback works with \link[bbotk:ContextOptimization]{bbotk::ContextOptimization} and \link{ContextEval}.
}
\details{
When implementing a callback, each functions must have two arguments named \code{callback} and \code{context}.

A callback can write data to the state (\verb{$state}), e.g. settings that affect the callback itself.
Avoid writing large data the state.
This can slow down the feature selection when the evaluation of configurations is parallelized.

Feature selection callbacks access two different contexts depending on the stage.
The stages \code{on_eval_after_design}, \code{on_eval_after_benchmark}, \code{on_eval_before_archive} access \link{ContextEval}.
This context can be used to customize the evaluation of a batch of feature sets.
Changes to the state of callback are lost after the evaluation of a batch and changes to the fselect instance or the fselector are not possible.
Persistent data should be written to the archive via \verb{$aggregated_performance} (see \link{ContextEval}).
The other stages access \link{ContextOptimization}.
This context can be used to modify the fselect instance, archive, fselector and final result.
There are two different contexts because the evaluation can be parallelized i.e. multiple instances of \link{ContextEval} exists on different workers at the same time.
}
\examples{
# Write archive to disk
callback_fselect("mlr3fselect.backup",
  on_optimization_end = function(callback, context) {
    saveRDS(context$instance$archive, "archive.rds")
  }
)
}
