% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sugar.R
\name{srlrnc}
\alias{srlrnc}
\title{Syntactic Sugar Surrogate Learner Collection Construction}
\usage{
srlrnc(learners, archive = NULL, x_cols = NULL, y_cols = NULL, ...)
}
\arguments{
\item{learners}{(List of \link[mlr3:LearnerRegr]{mlr3::LearnerRegr})\cr
\link[mlr3:LearnerRegr]{mlr3::LearnerRegr} that are to be used.}

\item{archive}{(\code{NULL} | \link[bbotk:Archive]{bbotk::Archive})\cr
\link[bbotk:Archive]{bbotk::Archive} of the \link[bbotk:OptimInstance]{bbotk::OptimInstance} used.
Can also be \code{NULL}.}

\item{x_cols}{(\code{NULL} | \code{character()})\cr
Names of columns in the \link[bbotk:Archive]{bbotk::Archive} that should be used as features.
Can also be \code{NULL}.}

\item{y_cols}{(\code{NULL} | \code{character()})\cr
Names of the columns in the \link[bbotk:Archive]{bbotk::Archive} that should be used as targets.
Can also be \code{NULL}.}

\item{...}{(named \code{list()})\cr
Named arguments passed to the constructor, to be set as parameters in the
\link[paradox:ParamSet]{paradox::ParamSet}.}
}
\value{
\link{SurrogateLearnerCollection}
}
\description{
This function allows to construct a \link{SurrogateLearnerCollection} in the spirit
of \code{mlr_sugar} from \CRANpkg{mlr3}.
}
\examples{
srlrnc(list(lrn("regr.featureless"), lrn("regr.featureless")), catch_errors = FALSE)
}
