% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OMLFlow.R
\name{oml_flow}
\alias{oml_flow}
\alias{OMLFlow}
\title{Interface to OpenML Flows}
\description{
This is the class for flows served on \href{https://www.openml.org/search?type=flow&sort=runs}{OpenML}.
Flows represent machine learning algorithms.
This object can also be constructed using the sugar function \code{\link[=oflw]{oflw()}}.
}
\section{mlr3 Integration}{

\itemize{
\item Obtain a \link[mlr3:Learner]{mlr3::Learner} using \code{\link[mlr3:as_learner]{mlr3::as_learner()}}.
}
}

\examples{
try({
  library("mlr3")
  # mlr3 flow:
  flow = OMLFlow$new(id = 19103)
  # using sugar
  flow = oflw(id = 19103)
  learner = as_learner(flow, "classif")
  # python flow
  python_flow = OMLFlow$new(19090)
  # conversion to pseudo Learner
  plearner = as_learner(python_flow, "classif")
  }, silent = TRUE)
}
\references{
Vanschoren J, van Rijn JN, Bischl B, Torgo L (2014).
\dQuote{OpenML.}
\emph{ACM SIGKDD Explorations Newsletter}, \bold{15}(2), 49--60.
\doi{10.1145/2641190.2641198}.
}
\section{Super class}{
\code{\link[mlr3oml:OMLObject]{mlr3oml::OMLObject}} -> \code{OMLFlow}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{parameter}}{(\code{data.table})\cr
The parameters of the flow.}

\item{\code{dependencies}}{(\code{character()})\cr
The dependencies of the flow.}

\item{\code{tags}}{(\code{character()})\cr
Returns all tags of the object.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OMLFlow-new}{\code{OMLFlow$new()}}
\item \href{#method-OMLFlow-print}{\code{OMLFlow$print()}}
\item \href{#method-OMLFlow-clone}{\code{OMLFlow$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3oml" data-topic="OMLObject" data-id="help"><a href='../../mlr3oml/html/OMLObject.html#method-OMLObject-help'><code>mlr3oml::OMLObject$help()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OMLFlow-new"></a>}}
\if{latex}{\out{\hypertarget{method-OMLFlow-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OMLFlow$new(id, cache = cache_default(), test_server = test_server_default())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{integer(1)})\cr
OpenML id for the object.}

\item{\code{cache}}{(\code{logical(1)} | \code{character(1)})\cr
See field \code{cache} for an explanation of possible values.
Defaults to value of option \code{"mlr3oml.cache"}, or \code{FALSE} if not set.}

\item{\code{test_server}}{(\code{character(1)})\cr
Whether to use the OpenML test server or public server.
Defaults to value of option \code{"mlr3oml.test_server"}, or \code{FALSE} if not set.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OMLFlow-print"></a>}}
\if{latex}{\out{\hypertarget{method-OMLFlow-print}{}}}
\subsection{Method \code{print()}}{
Prints the object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OMLFlow$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OMLFlow-clone"></a>}}
\if{latex}{\out{\hypertarget{method-OMLFlow-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OMLFlow$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
