% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OMLCollection.R
\name{oml_collection}
\alias{oml_collection}
\alias{OMLCollection}
\title{OpenML Collection}
\description{
This is the class for collections (previously known as studies) served on
\url{https://www.openml.org}.
A collection can either be a \href{https://www.openml.org/search?type=study&study_type=task}{task collection}
or \href{https://www.openml.org/search?type=study&study_type=run}{run collection}.
This object can also be constructed using the sugar function \code{\link[=ocl]{ocl()}}.

\strong{Run Collection}

A run collection contains runs, flows, datasets and tasks.
The primary object are the runs (\code{main_entity_type} is \code{"run"}).
The the flows, datasets and tasks are those used in the runs.

\strong{Task Collection}
A task collection (\code{main_entity_type = "task"}) contains tasks and datasets.
The primary object are the tasks (\code{main_entity_type} is \code{"task"}).
The datasets are those used in the tasks.

\emph{Note}: All Benchmark Suites on OpenML are also collections.
}
\section{Caching}{

Because collections on OpenML can be modified (ids can be added), it is not possible to cache
this object.
}

\section{mlr3 Intergration}{

\itemize{
\item Obtain a list of \link[mlr3:Task]{mlr3::Task}s using \link[mlr3:as_task]{mlr3::as_tasks}.
\item Obtain a list of \link[mlr3:Resampling]{mlr3::Resampling}s using \link[mlr3:as_resampling]{mlr3::as_resamplings}.
\item Obtain a list of \link[mlr3:Learner]{mlr3::Learner}s using \link[mlr3:as_learner]{mlr3::as_learners} (if main_entity_type is "run").
\item Obtain a \link[mlr3:BenchmarkResult]{mlr3::BenchmarkResult} using \link[mlr3:as_benchmark_result]{mlr3::as_benchmark_result} (if main_entity_type is "run").
}
}

\examples{
# For technical reasons, examples cannot be included in this R package.
# Instead, these are some relevant resources:
#
# Large-Scale Benchmarking chapter in the mlr3book:
# https://mlr3book.mlr-org.com/chapters/chapter11/large-scale_benchmarking.html
#
# Package Article:
# https://mlr3oml.mlr-org.com/articles/tutorial.html
}
\references{
Vanschoren J, van Rijn JN, Bischl B, Torgo L (2014).
\dQuote{OpenML.}
\emph{ACM SIGKDD Explorations Newsletter}, \bold{15}(2), 49--60.
\doi{10.1145/2641190.2641198}.
}
\section{Super class}{
\code{\link[mlr3oml:OMLObject]{mlr3oml::OMLObject}} -> \code{OMLCollection}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{desc}}{(\code{list()})\cr
Colllection description (meta information), downloaded and converted from the JSON API response.}

\item{\code{parquet}}{(\code{logical(1)})\cr
Whether to use parquet.}

\item{\code{main_entity_type}}{(\code{character(n)})\cr
The main entity type, either \code{"run"} or \code{"task"}.}

\item{\code{flow_ids}}{(\code{integer(n)})\cr
An vector containing the flow ids of the collection.}

\item{\code{data_ids}}{(\code{integer(n)})\cr
An vector containing the data ids of the collection.}

\item{\code{run_ids}}{(\code{integer(n)})\cr
An vector containing the run ids of the collection.}

\item{\code{task_ids}}{(\code{integer(n)})\cr
An vector containing the task ids of the collection.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OMLCollection-new}{\code{OMLCollection$new()}}
\item \href{#method-OMLCollection-print}{\code{OMLCollection$print()}}
\item \href{#method-OMLCollection-download}{\code{OMLCollection$download()}}
\item \href{#method-OMLCollection-clone}{\code{OMLCollection$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3oml" data-topic="OMLObject" data-id="help"><a href='../../mlr3oml/html/OMLObject.html#method-OMLObject-help'><code>mlr3oml::OMLObject$help()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OMLCollection-new"></a>}}
\if{latex}{\out{\hypertarget{method-OMLCollection-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OMLCollection$new(id, test_server = test_server_default())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{integer(1)})\cr
OpenML id for the object.}

\item{\code{test_server}}{(\code{character(1)})\cr
Whether to use the OpenML test server or public server.
Defaults to value of option \code{"mlr3oml.test_server"}, or \code{FALSE} if not set.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OMLCollection-print"></a>}}
\if{latex}{\out{\hypertarget{method-OMLCollection-print}{}}}
\subsection{Method \code{print()}}{
Prints the object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OMLCollection$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OMLCollection-download"></a>}}
\if{latex}{\out{\hypertarget{method-OMLCollection-download}{}}}
\subsection{Method \code{download()}}{
Downloads the whole object for offline usage.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OMLCollection$download()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OMLCollection-clone"></a>}}
\if{latex}{\out{\hypertarget{method-OMLCollection-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OMLCollection$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
