% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{\%>>\%}
\alias{\%>>\%}
\title{PipeOp Composition Operator}
\usage{
g1 \%>>\% g2
}
\arguments{
\item{g1}{(\code{\link{Graph}} | \code{\link{PipeOp}} | \code{\link[mlr3:Learner]{Learner}} | \code{\link[mlr3filters:Filter]{Filter}} | \code{list} | \code{...}) \cr
\code{\link{Graph}} / \code{\link{PipeOp}} / object-convertible-to-\code{\link{PipeOp}} to put in front of \code{g2}.}

\item{g2}{(\code{\link{Graph}} | \code{\link{PipeOp}} | \code{\link[mlr3:Learner]{Learner}} | \code{\link[mlr3filters:Filter]{Filter}} | \code{list} | \code{...}) \cr
\code{\link{Graph}} / \code{\link{PipeOp}} / object-convertible-to-\code{\link{PipeOp}} to put after  \code{g1}.}
}
\value{
\code{\link{Graph}}: the constructed \code{\link{Graph}}.
}
\description{
This operator "pipes" data from the source \code{g1} into the sink \code{g2}. Both source and sink can either be
a \code{\link{Graph}} or a \code{\link{PipeOp}} (or an object that can be automatically converted into a \code{\link{Graph}} or \code{\link{PipeOp}}, see \code{\link[=as_graph]{as_graph()}} and \code{\link[=as_pipeop]{as_pipeop()}}).

\verb{\%>>\%} tries to automatically match output channels of \code{g1} to input channels of \code{g2}; this is only possible if either
\itemize{
\item the number of output channels of \code{g1} (as given by \code{g1$output}) is equal to the
number of input channels of \code{g2} (as given by \code{g2$input}), or
\item \code{g1} has only one output channel (i.e. \code{g1$output} has one line), or
\item \code{g2} has only one input channel, which is a \emph{vararg} channel (i.e. \code{g2$input} has one line, with \code{name} entry \code{"..."}).
}

Connections between channels are created in the
order in which they occur in \code{g1} and \code{g2}, respectively: \code{g1}'s output channel 1 is connected to \code{g2}'s input
channel 1, channel 2 to 2 etc.

This operator always created deep copies of its input arguments, so they cannot be modified by reference afterwards.
To access individual \code{\link{PipeOp}}s after composition, use the resulting \code{\link{Graph}}'s \verb{$pipeops} list.

Both arguments of \verb{\%>>\%} are automatically converted to \code{\link{Graph}}s using \code{\link[=as_graph]{as_graph()}}; this means that objects on either side may be objects
that can be automatically converted to \code{\link{PipeOp}}s (such as \code{\link[mlr3:Learner]{Learner}}s or \code{\link[mlr3filters:Filter]{Filter}}s), or that can
be converted to \code{\link{Graph}}s. This means, in particular, \code{list}s of \code{\link{Graph}}s, \code{\link{PipeOp}}s or objects convertible to that, because
\code{\link[=as_graph]{as_graph()}} automatically applies \code{\link[=gunion]{gunion()}} to \code{list}s. See examples.
}
\examples{
o1 = PipeOpScale$new()
o2 = PipeOpPCA$new()
o3 = PipeOpFeatureUnion$new(2)

# The following two are equivalent:
pipe1 = o1 \%>>\% o2

pipe2 = Graph$new()$
  add_pipeop(o1$clone(deep = TRUE))$
  add_pipeop(o2$clone(deep = TRUE))$
  add_edge(o1$id, o2$id)

# Note automatical gunion() of lists.
# The following three are equivalent:
graph1 = list(o1, o2) \%>>\% o3

graph2 = gunion(list(o1, o2)) \%>>\% o3

graph3 = Graph$new()$
  add_pipeop(o1$clone(deep = TRUE))$
  add_pipeop(o2$clone(deep = TRUE))$
  add_pipeop(o3$clone(deep = TRUE))$
  add_edge(o1$id, o3$id, dst_channel = 1)$
  add_edge(o2$id, o3$id, dst_channel = 2)
}
\seealso{
Other Graph operators: 
\code{\link{as_graph}()},
\code{\link{as_pipeop}()},
\code{\link{assert_graph}()},
\code{\link{assert_pipeop}()},
\code{\link{greplicate}()},
\code{\link{gunion}()}
}
\concept{Graph operators}
