% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_average.R
\name{surv_averager}
\alias{surv_averager}
\title{Average Survival Predictions}
\usage{
surv_averager(learners, param_vals = list())
}
\arguments{
\item{learners}{\code{(list())} \cr
List of \link{LearnerSurv}s to average.}

\item{param_vals}{\code{(list())} \cr
Parameters, including weights, to pass to \link{PipeOpSurvAvg}.}
}
\value{
\link[mlr3pipelines:GraphLearner]{mlr3pipelines::GraphLearner}
}
\description{
This is a wrapper around the \link{PipeOpSurvAvg} pipe operation, which
simplifies graph creation.
}
\details{
For full details see \link{PipeOpSurvAvg}.
}
\examples{
\dontrun{
library("mlr3")

task = tgen("simsurv")$generate(5)
avg = surv_averager(
  learners = lrns(c("surv.kaplan", "surv.coxph")),
  param_vals = list(weights = c(0.1, 0.9))
 )
avg$train(task)$predict(task)
}
}
