% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_spatial.R
\name{predict_spatial}
\alias{predict_spatial}
\title{Predict on Spatial Objects with mlr3 Learners}
\usage{
predict_spatial(
  task,
  learner,
  chunksize = 200L,
  format = "terra",
  filename = NULL
)
}
\arguments{
\item{task}{(\link{Task}).
Task with \link{DataBackendRaster}.}

\item{learner}{(\link{Learner}).
Learner with trained model.}

\item{chunksize}{(\code{integer(1)})\cr
The chunksize determines in how many subparts the prediction task will be
split into. The value can be roughly thought of as megabyte of a raster file
on disk. For example, if a prediction on a 1 GB file would be carried out
with \code{chunksize = 100L}, the prediction would happen in 10 chunks.

The default of \code{chunksize = 1000L} might be a good compromise between speed
and memory usage. If you find yourself running out of memory, reduce this
value.}

\item{format}{(\code{character(1)})\cr
Output class of the resulting object.
Accepted values are \code{"raster"}, \code{"stars"} and \code{"terra"} if the input is a \link{DataBackendRaster}.
Note that when choosing something else than \code{"terra"}, the spatial object is converted into the respective format which might cause overhead both in runtime and memory allocation.}

\item{filename}{(\code{character(1)})\cr
Path where the spatial object should be written to.}
}
\value{
Spatial object of class given in argument \code{format}.
}
\description{
This function allows to directly predict mlr3 learners on various spatial objects.
}
\examples{
library(terra, exclude = "resample")

# fit rpart on training points
task_train = tsk("leipzig")
learner = lrn("classif.rpart")
learner$train(task_train)

# load raster and convert to task
stack = rast(system.file("extdata", "leipzig_raster.tif", package = "mlr3spatial"))
task_predict = as_task_unsupervised(stack, id = "leipzig")

# predict land cover classes
pred = predict_spatial(task_predict, learner, chunksize = 1L)
}
