% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_task_classif_st.R
\name{as_task_classif_st}
\alias{as_task_classif_st}
\alias{as_task_classif_st.TaskClassifST}
\alias{as_task_classif_st.data.frame}
\alias{as_task_classif_st.DataBackend}
\alias{as_task_classif_st.sf}
\title{Convert to a Spatiotemporal Classification Task}
\usage{
as_task_classif_st(x, ...)

\method{as_task_classif_st}{TaskClassifST}(x, clone = FALSE, ...)

\method{as_task_classif_st}{data.frame}(
  x,
  target,
  id = deparse(substitute(x)),
  positive = NULL,
  coordinate_names,
  crs = NA_character_,
  coords_as_features = FALSE,
  label = NA_character_,
  ...
)

\method{as_task_classif_st}{DataBackend}(
  x,
  target,
  id = deparse(substitute(x)),
  positive = NULL,
  coordinate_names,
  crs,
  coords_as_features = FALSE,
  label = NA_character_,
  ...
)

\method{as_task_classif_st}{sf}(
  x,
  target = NULL,
  id = deparse(substitute(x)),
  positive = NULL,
  coords_as_features = FALSE,
  label = NA_character_,
  ...
)
}
\arguments{
\item{x}{(any)\cr
Object to convert.}

\item{...}{(any)\cr
Additional arguments.}

\item{clone}{(\code{logical(1)})\cr
If \code{TRUE}, ensures that the returned object is not the same as the input \code{x}.}

\item{target}{(\code{character(1)})\cr
Name of the target column.}

\item{id}{(\code{character(1)})\cr
Id for the new task.
Defaults to the (deparsed and substituted) name of the data argument.}

\item{positive}{(\code{character(1)})\cr
Only for binary classification: Name of the positive class.
The levels of the target columns are reordered accordingly, so that the
first element of \verb{$class_names} is the positive class, and the second
element is the negative class.}

\item{coordinate_names}{(\code{character(1)})\cr
The column names of the coordinates in the data.}

\item{crs}{(\code{character(1)})\cr
Coordinate reference system.
WKT2 or EPSG string.}

\item{coords_as_features}{(\code{logical(1)})\cr
If \code{TRUE}, coordinates are used as features.
This is a shortcut for
\code{task$set_col_roles(c("x", "y"), role = "feature")} with the assumption
that the coordinates in the data are named \code{"x"} and \code{"y"}.}

\item{label}{(\code{character(1)})\cr
Label for the new instance. Shown in \code{as.data.table(mlr_tasks)}.}
}
\value{
\link{TaskClassifST}.
}
\description{
Convert an object to a \link{TaskClassifST}.
This is a S3 generic for the following objects:
\enumerate{
\item \link{TaskClassifST}: Ensure the identity.
\item \code{\link[=data.frame]{data.frame()}} and \link{DataBackend}: Provides an alternative to the
constructor of \link{TaskClassifST}.
\item \link[sf:sf]{sf::sf}: Extracts spatial meta data before construction.
\item \link{TaskRegr}: Calls \code{\link[=convert_task]{convert_task()}}.
}
}
\examples{
if (mlr3misc::require_namespaces(c("sf"), quietly = TRUE)) {
  library("mlr3")
  data("ecuador", package = "mlr3spatiotempcv")

  # data.frame
  as_task_classif_st(ecuador, target = "slides", positive = "TRUE",
    coords_as_features = FALSE,
    crs = "+proj=utm +zone=17 +south +datum=WGS84 +units=m +no_defs",
    coordinate_names = c("x", "y"))

  # sf
  ecuador_sf = sf::st_as_sf(ecuador, coords = c("x", "y"), crs = 32717)
  as_task_classif_st(ecuador_sf, target = "slides", positive = "TRUE")
}
}
