% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TaskClassif_mnist.R
\name{mlr_tasks_mnist}
\alias{mlr_tasks_mnist}
\title{MNIST Image classification}
\source{
\url{https://torchvision.mlverse.org/reference/mnist_dataset.html}
}
\description{
Classic MNIST image classification.

The underlying \code{\link[mlr3:DataBackend]{DataBackend}} contains columns \code{"label"}, \code{"image"}, \code{"row_id"}, \code{"split"}, where the last column
indicates whether the row belongs to the train or test set.

The first 60000 rows belong to the training set, the last 10000 rows to the test set.
}
\section{Construction}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{tsk("mnist")
}\if{html}{\out{</div>}}
}

\section{Download}{

The \link[mlr3:Task]{task}'s backend is a \code{\link{DataBackendLazy}} which will download the data once it is requested.
Other meta-data is already available before that.
You can cache these datasets by setting the \code{mlr3torch.cache} option to \code{TRUE} or to a specific path to be used
as the cache directory.
}

\section{Properties}{

\itemize{
\item Task type: \dQuote{classif}
\item Properties: \dQuote{multiclass}
\item Has Missings: no
\item Target: \dQuote{label}
\item Features: \dQuote{image}
\item Data Dimension: 70000x4
}
}

\examples{
\dontshow{if (torch::torch_is_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
task = tsk("mnist")
task
\dontshow{\}) # examplesIf}
}
\references{
Lecun, Y., Bottou, L., Bengio, Y., Haffner, P. (1998).
\dQuote{Gradient-based learning applied to document recognition.}
\emph{Proceedings of the IEEE}, \bold{86}(11), 2278-2324.
\doi{10.1109/5.726791}.
}
