% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TerminatorModelTime.R
\name{TerminatorModelTime}
\alias{TerminatorModelTime}
\alias{mlr_terminators_model_time}
\title{Terminator that stops after a budget of model evaluation time is depleted}
\format{\link[R6:R6Class]{R6::R6Class} object inheriting from \link{Terminator}.}
\description{
Class to terminate the tuning after a given model evaluation budget is exceeded.
The terminator measures the used time to train and predict all models contained
in the archive.
}
\section{Construction}{
\preformatted{TerminatorModelTime$new()
term("model_time")
}
}

\section{Parameters}{

\itemize{
\item \code{secs} :: \code{numeric(1)}\cr
Maximum allowed time, in seconds, default is 0.
}
}

\examples{
TerminatorModelTime$new()
term("model_time", secs = 10 * 3600)
}
\seealso{
Other Terminator: 
\code{\link{TerminatorClockTime}},
\code{\link{TerminatorCombo}},
\code{\link{TerminatorEvals}},
\code{\link{TerminatorNone}},
\code{\link{TerminatorPerfReached}},
\code{\link{TerminatorStagnation}},
\code{\link{Terminator}},
\code{\link{mlr_terminators}}
}
\concept{Terminator}
