% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TerminatorStagnation.R
\name{TerminatorStagnation}
\alias{TerminatorStagnation}
\alias{mlr_terminators_stagnation}
\title{Terminator that stops when tuning does not improve}
\format{\link[R6:R6Class]{R6::R6Class} object inheriting from \link{Terminator}.}
\description{
Class to terminate the tuning after the performance stagnates, i.e. does not improve more than
\code{threshold} over the last \code{iters} iterations.
}
\section{Construction}{
\preformatted{t = TerminatorStagnation$new()
}
}

\section{Parameters}{

\itemize{
\item \code{iters} :: \code{integer(1)}\cr
Number of iterations to evaluate the performance improvement on, default is 10.
\item \code{threshold} :: \code{numeric(1)}\cr
If the improvement is less than \code{threshold}, tuning is stopped, default is \code{0}.
}
}

\examples{
TerminatorStagnation$new()
term("stagnation", iters = 5, threshold = 1e-5)
}
\seealso{
Other Terminator: 
\code{\link{TerminatorClockTime}},
\code{\link{TerminatorCombo}},
\code{\link{TerminatorEvals}},
\code{\link{TerminatorModelTime}},
\code{\link{TerminatorNone}},
\code{\link{TerminatorPerfReached}},
\code{\link{Terminator}},
\code{\link{mlr_terminators}}
}
\concept{Terminator}
