% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerClassifRpart.R, R/LearnerRegrRpart.R
\name{autoplot.LearnerClassifRpart}
\alias{autoplot.LearnerClassifRpart}
\alias{autoplot.LearnerRegrRpart}
\title{Plots for Rpart Learners}
\usage{
\method{autoplot}{LearnerClassifRpart}(object, theme = theme_minimal(), ...)

\method{autoplot}{LearnerRegrRpart}(object, theme = theme_minimal(), ...)
}
\arguments{
\item{object}{(\link[mlr3:mlr_learners_classif.rpart]{mlr3::LearnerClassifRpart} | \link[mlr3:mlr_learners_regr.rpart]{mlr3::LearnerRegrRpart}).}

\item{theme}{(\code{\link[ggplot2:theme]{ggplot2::theme()}})\cr
The \code{\link[ggplot2:ggtheme]{ggplot2::theme_minimal()}} is applied by default to all plots.}

\item{...}{(ignored).}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
}
\description{
Visualizations rpart trees using the package \CRANpkg{ggparty}.
}
\examples{
if (requireNamespace("mlr3")) {
  library(mlr3)
  library(mlr3viz)

  # classification
  task = tsk("iris")
  learner = lrn("classif.rpart", keep_model = TRUE)
  learner$train(task)
  autoplot(learner)

  # regression
  task = tsk("mtcars")
  learner = lrn("regr.rpart", keep_model = TRUE)
  learner$train(task)
  autoplot(learner)
}
}
