% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionClassif.R
\name{autoplot.PredictionClassif}
\alias{autoplot.PredictionClassif}
\title{Plots for Classification Predictions}
\usage{
\method{autoplot}{PredictionClassif}(
  object,
  type = "stacked",
  measure = NULL,
  theme = theme_minimal(),
  ...
)
}
\arguments{
\item{object}{(\link[mlr3:PredictionClassif]{mlr3::PredictionClassif}).}

\item{type}{(character(1)):\cr
Type of the plot. See description.}

\item{measure}{(\link[mlr3:Measure]{mlr3::Measure})\cr
Performance measure to use.}

\item{theme}{(\code{\link[ggplot2:theme]{ggplot2::theme()}})\cr
The \code{\link[ggplot2:ggtheme]{ggplot2::theme_minimal()}} is applied by default to all plots.}

\item{...}{(ignored).}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
}
\description{
Visualizations for \link[mlr3:PredictionClassif]{mlr3::PredictionClassif}.
The argument \code{type} controls what kind of plot is drawn.
Possible choices are:
\itemize{
\item \code{"stacked"} (default): Stacked barplot of true and estimated class labels.
\item \code{"roc"}: ROC curve (1 - specificity on x, sensitivity on y).
Requires package \CRANpkg{precrec}.
\item \code{"prc"}: Precision recall curve.
Requires package \CRANpkg{precrec}.
\item \code{"threshold"}: Systematically varies the threshold of the \link[mlr3:PredictionClassif]{mlr3::PredictionClassif} object and plots the resulting performance as returned by \code{measure}.
}
}
\examples{
if (requireNamespace("mlr3")) {
  library(mlr3)
  library(mlr3viz)

  task = tsk("spam")
  learner = lrn("classif.rpart", predict_type = "prob")
  object = learner$train(task)$predict(task)

  head(fortify(object))
  autoplot(object)
  autoplot(object, type = "roc")
  autoplot(object, type = "prc")
}
}
\references{
Saito T, Rehmsmeier M (2017).
\dQuote{Precrec: fast and accurate precision-recall and ROC curve calculations in R.}
\emph{Bioinformatics}, \bold{33}(1), 145-147.
\doi{10.1093/bioinformatics/btw570}.
}
