% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_c_index.R
\name{c_index}
\alias{c_index}
\title{c_index}
\usage{
c_index(ground_truth, predictions)
}
\arguments{
\item{ground_truth}{A `survival::Surv` object with the ground truth.}

\item{predictions}{A vector with predictions.}
}
\description{
Calculate the Harrell's concordance index (C-index)
}
\details{
A wrapper function around [glmnet::Cindex()] for use with `mlexperiments`.
}
\examples{
set.seed(123)
gt <- survival::Surv(
  time = rnorm(100, 50, 15),
  event = sample(0:1, 100, TRUE)
)
preds <- rbeta(100, 2, 5)

c_index(gt, preds)

}
\seealso{
[glmnet::Cindex()]
}
