% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morph.R
\name{threshold}
\alias{threshold}
\title{Threshold a numeric array or vector}
\usage{
threshold(x, level, method = c("literal", "kmeans"), binarise = TRUE)
}
\arguments{
\item{x}{A numeric vector or array.}

\item{level}{The literal threshold level, if required.}

\item{method}{The method to use to calculate the threshold. If
\code{"literal"} (the default) then the value of \code{level} will be
used. If \code{"kmeans"} then the threshold value will be determined
implicitly using k-means clustering.}

\item{binarise}{Whether to set suprathreshold elements to unity (if
\code{TRUE}), or leave them at their original values (if \code{FALSE}).}
}
\description{
This function thresholds an array or vector, setting elements below the
threshold value to zero. The threshold can be given literally or calculated
using k-means clustering.
}
\examples{
x <- c(0.1, 0.05, 0.95, 0.85, 0.15, 0.9)
threshold(x, method="kmeans")
threshold(x, 0.5)
}
\author{
Jon Clayden <code@clayden.org>
}
\seealso{
\code{\link{binarise}}
}

