% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replext_helpers_pgsql.R
\name{runSimulation_pgsql}
\alias{runSimulation_pgsql}
\title{Execute Simulation Based on User Input (PostgreSQL Integration)}
\usage{
runSimulation_pgsql(input)
}
\arguments{
\item{input}{A list containing the user input parameters from the Shiny application.}
}
\value{
The result of the simulation, which can be either from \code{replext_t1_c1}
(Order Constrained ANOVA) or \code{replext_t2_c1} (Inequality Constrained Linear
Regression), depending on the selected cell block.
}
\description{
This internal helper function runs the appropriate simulation function based
on the user-selected cell block in the Replext Shiny application. It handles
the dynamic execution of either ANOVA or regression simulations based on the
parameters specified by the user. The *_pgsql version of the function was built
for integration with PostgreSQL
}
\details{
The function determines which simulation function to call
(\code{replext_t1_c1} or \code{replext_t2_c1}) based on the prefix of the \code{cellBlock}
input parameter. The function passes user-specified parameters to the chosen
simulation function and returns the simulation results.
}
\keyword{internal}
