% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmb-methods.R
\name{mmrm_tmb_methods}
\alias{mmrm_tmb_methods}
\alias{coef.mmrm_tmb}
\alias{fitted.mmrm_tmb}
\alias{model.frame.mmrm_tmb}
\alias{logLik.mmrm_tmb}
\alias{formula.mmrm_tmb}
\alias{vcov.mmrm_tmb}
\alias{VarCorr.mmrm_tmb}
\alias{VarCorr}
\alias{deviance.mmrm_tmb}
\alias{AIC.mmrm_tmb}
\alias{BIC.mmrm_tmb}
\alias{print.mmrm_tmb}
\title{Methods for \code{mmrm_tmb} Objects}
\usage{
\method{coef}{mmrm_tmb}(object, complete = TRUE, ...)

\method{fitted}{mmrm_tmb}(object, ...)

\method{model.frame}{mmrm_tmb}(formula, full = FALSE, ...)

\method{logLik}{mmrm_tmb}(object, ...)

\method{formula}{mmrm_tmb}(x, ...)

\method{vcov}{mmrm_tmb}(object, complete = TRUE, ...)

\method{VarCorr}{mmrm_tmb}(x, sigma = NA, ...)

\method{deviance}{mmrm_tmb}(object, ...)

\method{AIC}{mmrm_tmb}(object, corrected = FALSE, ..., k = 2)

\method{BIC}{mmrm_tmb}(object, ...)

\method{print}{mmrm_tmb}(x, ...)
}
\arguments{
\item{object}{(\code{mmrm_tmb})\cr the fitted MMRM object.}

\item{complete}{(\code{flag})\cr whether to include potential non-estimable
coefficients.}

\item{...}{not used.}

\item{formula}{(\code{mmrm_tmb})\cr same as \code{object}.}

\item{full}{(\code{flag})\cr whether to include subject, visit and weight variables.}

\item{x}{(\code{mmrm_tmb})\cr same as \code{object}.}

\item{sigma}{cannot be used (this parameter does not exist in MMRM).}

\item{corrected}{(\code{flag})\cr whether corrected AIC should be calculated.}

\item{k}{(\code{number})\cr the penalty per parameter to be used; default \code{k = 2}
is the classical AIC.}
}
\value{
Depends on the method, see Functions.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\section{Functions}{
\itemize{
\item \code{coef(mmrm_tmb)}: obtains the estimated coefficients.

\item \code{fitted(mmrm_tmb)}: obtains the fitted values.

\item \code{model.frame(mmrm_tmb)}: obtains the model frame.

\item \code{logLik(mmrm_tmb)}: obtains the attained log likelihood value.

\item \code{formula(mmrm_tmb)}: obtains the used formula.

\item \code{vcov(mmrm_tmb)}: obtains the variance-covariance matrix estimate
for the coefficients.

\item \code{VarCorr(mmrm_tmb)}: obtains the variance-covariance matrix estimate
for the residuals.

\item \code{deviance(mmrm_tmb)}: obtains the deviance, which is defined here
as twice the negative log likelihood, which can either be integrated
over the coefficients for REML fits or the usual one for ML fits.

\item \code{AIC(mmrm_tmb)}: obtains the Akaike Information Criterion,
where the degrees of freedom are the number of variance parameters (\code{n_theta}).
If \code{corrected}, then this is multiplied with \code{m / (m - n_theta - 1)} where
\code{m} is the number of observations minus the number of coefficients, or
\code{n_theta + 2} if it is smaller than that \insertCite{hurvich1989regression,burnham1998practical}{mmrm}.

\item \code{BIC(mmrm_tmb)}: obtains the Bayesian Information Criterion,
which is using the natural logarithm of the number of subjects for the
penalty parameter \code{k}.

\item \code{print(mmrm_tmb)}: prints the object.

}}
\examples{
formula <- FEV1 ~ RACE + SEX + ARMCD * AVISIT + us(AVISIT | USUBJID)
object <- fit_mmrm(formula, fev_data, weights = rep(1, nrow(fev_data)))
# Estimated coefficients:
coef(object)
# Fitted values:
fitted(object)
# Model frame:
model.frame(object)
model.frame(object, full = TRUE)
# Log likelihood given the estimated parameters:
logLik(object)
# Formula which was used:
formula(object)
# Variance-covariance matrix estimate for coefficients:
vcov(object)
# Variance-covariance matrix estimate for residuals:
VarCorr(object)
# REML criterion (twice the negative log likelihood):
deviance(object)
# AIC:
AIC(object)
AIC(object, corrected = TRUE)
# BIC:
BIC(object)
}
\references{
\itemize{
\item \insertRef{hurvich1989regression}{mmrm}
\item \insertRef{burnham1998practical}{mmrm}
}
}
